/*
 * Decompiled with CFR 0.152.
 */
package de.kgrupp.inoksjavautils.transform;

import de.kgrupp.inoksjavautils.transform.IOUtils;
import de.kgrupp.inoksjavautils.transform.XmlUtils;
import de.kgrupp.monads.result.Result;
import java.io.InputStream;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXParseException;

class XmlUtilsTest {
    private static final MyClass EXAMPLE1 = new MyClass(1, 1.0);
    private static final String EXAMPLE1_XML = "<my someDouble=\"1.0\"><anInt>1</anInt></my>";
    private static final MyClass EXAMPLE2 = new MyClass(2, 2.0);
    private static final String EXAMPLE2_XML = "<my someDouble=\"2.0\"><anInt>2</anInt></my>";
    private static final String EXAMPLE_STRING = "<test><my someDouble=\"1.0\"><anInt>1</anInt></my><my someDouble=\"2.0\"><anInt>2</anInt></my></test>";

    XmlUtilsTest() {
    }

    @Test
    void unmarshalFirst() {
        Result result = XmlUtils.unmarshalFirst((String)"my", (String)EXAMPLE_STRING, MyClass.class);
        Assertions.assertEquals((Object)Result.of((Object)EXAMPLE1), (Object)result);
    }

    @Test
    void unmarshalFirstNotFound() {
        Result result = XmlUtils.unmarshalFirst((String)"missing", (String)EXAMPLE_STRING, MyClass.class);
        Assertions.assertTrue((boolean)result.isError());
        Assertions.assertFalse((boolean)result.isInternalError());
    }

    @Test
    void unmarshalFirstInvalid() {
        Result result = XmlUtils.unmarshalFirst((String)"my", (String)"<test><my someDouble=\"1.0\"><anInt>1</anInt></my><my someDouble=\"2.0\"><anInt>2</anInt></my></test>INVALID", MyClass.class);
        Assertions.assertTrue((boolean)result.isInternalError());
        Assertions.assertEquals(SAXParseException.class, result.getThrowable().getClass());
    }

    @Test
    void unmarshalFirstInvalidType() {
        Result result = XmlUtils.unmarshalFirst((String)"my", (String)EXAMPLE_STRING.replace("1.0", "TEST"), MyClass.class);
        Assertions.assertTrue((boolean)result.isInternalError());
        Assertions.assertEquals(NumberFormatException.class, result.getThrowable().getClass());
    }

    @Test
    void unmarshalEach() {
        Result result = XmlUtils.unmarshalEach((String)"my", (String)EXAMPLE_STRING, MyClass.class);
        result.consumeOrFail(list -> {
            Assertions.assertEquals((int)2, (int)list.size());
            Assertions.assertEquals((Object)EXAMPLE1, list.get(0));
            Assertions.assertEquals((Object)EXAMPLE2, list.get(1));
        });
    }

    @Test
    void toIterable() {
        Document document = (Document)XmlUtils.parse((InputStream)((InputStream)IOUtils.stringToInputStream((String)EXAMPLE_STRING).getObject())).getObject();
        Iterable nodes = XmlUtils.toIterable((NodeList)document.getElementsByTagName("my"));
        List list = StreamSupport.stream(nodes.spliterator(), false).collect(Collectors.toList());
        Assertions.assertEquals((int)2, (int)list.size());
        Assertions.assertEquals((Object)"1", (Object)((Node)list.get(0)).getTextContent());
        Assertions.assertEquals((Object)"2", (Object)((Node)list.get(1)).getTextContent());
    }

    @Test
    void toIterableBreakIterator() {
        Document document = (Document)XmlUtils.parse((InputStream)((InputStream)IOUtils.stringToInputStream((String)EXAMPLE_STRING).getObject())).getObject();
        Iterable nodes = XmlUtils.toIterable((NodeList)document.getElementsByTagName("my"));
        Iterator iterator = nodes.iterator();
        iterator.next();
        iterator.next();
        Assertions.assertThrows(NoSuchElementException.class, iterator::next);
    }

    private static class MyClass {
        @XmlElement
        private int anInt;
        @XmlAttribute
        private double someDouble;

        public MyClass(int anInt, double someDouble) {
            this.anInt = anInt;
            this.someDouble = someDouble;
        }

        public MyClass() {
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof MyClass)) {
                return false;
            }
            MyClass other = (MyClass)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (this.anInt != other.anInt) {
                return false;
            }
            return Double.compare(this.someDouble, other.someDouble) == 0;
        }

        protected boolean canEqual(Object other) {
            return other instanceof MyClass;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            result = result * 59 + this.anInt;
            long $someDouble = Double.doubleToLongBits(this.someDouble);
            result = result * 59 + (int)($someDouble >>> 32 ^ $someDouble);
            return result;
        }

        public String toString() {
            return "XmlUtilsTest.MyClass(anInt=" + this.anInt + ", someDouble=" + this.someDouble + ")";
        }
    }
}

