/*
 * Decompiled with CFR 0.152.
 */
package de.kgrupp.inoksjavautils.transform;

import com.fasterxml.jackson.core.io.JsonEOFException;
import com.fasterxml.jackson.databind.exc.InvalidDefinitionException;
import de.kgrupp.inoksjavautils.transform.IOUtils;
import de.kgrupp.inoksjavautils.transform.JsonUtils;
import de.kgrupp.monads.result.Result;
import java.io.InputStream;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

class JsonUtilsTest {
    private static final MyClass EXAMPLE = new MyClass(1, 1.0);
    private static final String EXAMPLE_STRING = "{\"anInt\":1,\"someDouble\":1.0}";

    JsonUtilsTest() {
    }

    @Test
    void convertToJsonString() {
        Result result = JsonUtils.convertToJsonString((Object)EXAMPLE);
        Assertions.assertEquals((Object)Result.of((Object)EXAMPLE_STRING), (Object)result);
    }

    @Test
    void convertToJsonStringFails() {
        Result result = JsonUtils.convertToJsonString((Object)new Object(){});
        Assertions.assertTrue((boolean)result.isInternalError());
        Assertions.assertEquals(InvalidDefinitionException.class, result.getThrowable().getClass());
    }

    @Test
    void convertToObject() {
        Result result = JsonUtils.convertToObject((String)EXAMPLE_STRING, MyClass.class);
        Assertions.assertEquals((Object)Result.of((Object)EXAMPLE), (Object)result);
    }

    @Test
    void convertToObjectFail() {
        Result result = JsonUtils.convertToObject((String)"{", MyClass.class);
        Assertions.assertTrue((boolean)result.isInternalError());
        Assertions.assertEquals(JsonEOFException.class, result.getThrowable().getClass());
    }

    @Test
    void convertToObjectAsInputStream() {
        Result result = JsonUtils.convertToObject((InputStream)((InputStream)IOUtils.stringToInputStream((String)EXAMPLE_STRING).getObject()), MyClass.class);
        Assertions.assertEquals((Object)Result.of((Object)EXAMPLE), (Object)result);
    }

    @Test
    void convertToObjectUseDefaultOnError() {
        MyClass result = (MyClass)JsonUtils.convertToObjectUseDefaultOnError((String)EXAMPLE_STRING, MyClass.class, null);
        Assertions.assertEquals((Object)EXAMPLE, (Object)result);
    }

    @Test
    void convertToObjectUseDefaultOnErrorDefaultUsed() {
        MyClass result = (MyClass)JsonUtils.convertToObjectUseDefaultOnError((String)"{", MyClass.class, (Object)EXAMPLE);
        Assertions.assertEquals((Object)EXAMPLE, (Object)result);
    }

    private static class MyClass {
        private int anInt;
        private double someDouble;

        public int getAnInt() {
            return this.anInt;
        }

        public double getSomeDouble() {
            return this.someDouble;
        }

        public void setAnInt(int anInt) {
            this.anInt = anInt;
        }

        public void setSomeDouble(double someDouble) {
            this.someDouble = someDouble;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof MyClass)) {
                return false;
            }
            MyClass other = (MyClass)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (this.getAnInt() != other.getAnInt()) {
                return false;
            }
            return Double.compare(this.getSomeDouble(), other.getSomeDouble()) == 0;
        }

        protected boolean canEqual(Object other) {
            return other instanceof MyClass;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            result = result * 59 + this.getAnInt();
            long $someDouble = Double.doubleToLongBits(this.getSomeDouble());
            result = result * 59 + (int)($someDouble >>> 32 ^ $someDouble);
            return result;
        }

        public String toString() {
            return "JsonUtilsTest.MyClass(anInt=" + this.getAnInt() + ", someDouble=" + this.getSomeDouble() + ")";
        }

        public MyClass(int anInt, double someDouble) {
            this.anInt = anInt;
            this.someDouble = someDouble;
        }

        public MyClass() {
        }
    }
}

