/*
 * Decompiled with CFR 0.152.
 */
package de.kgrupp.inoksjavautils.transform;

import de.kgrupp.inoksjavautils.transform.IOUtils;
import de.kgrupp.monads.result.Result;
import java.io.IOException;
import java.io.InputStream;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

class IOUtilsTest {
    private InputStream stream;
    private InputStream failingStream;
    private static final String STRING = "023SDFjf20lks\u00e4.!\"\u00a7$%&/()=?```";

    IOUtilsTest() {
    }

    @BeforeEach
    void setUp() {
        this.stream = new InputStream(){
            private int count = 0;

            @Override
            public int read() {
                if (this.count < IOUtilsTest.STRING.getBytes().length) {
                    byte nextValue = IOUtilsTest.STRING.getBytes()[this.count];
                    ++this.count;
                    return nextValue;
                }
                return -1;
            }
        };
        this.failingStream = new InputStream(){

            @Override
            public int read() throws IOException {
                throw new IOException("JUST FAILS");
            }
        };
    }

    @Test
    void inputStreamToString() {
        Result result = IOUtils.inputStreamToString((InputStream)this.stream);
        Assertions.assertEquals((Object)Result.of((Object)STRING), (Object)result);
    }

    @Test
    void stringToInputStream() throws IOException {
        int expect;
        Result result = IOUtils.stringToInputStream((String)STRING);
        Assertions.assertTrue((boolean)result.isSuccess());
        do {
            int actual = ((InputStream)result.getObject()).read();
            expect = this.stream.read();
            Assertions.assertEquals((int)expect, (int)actual);
        } while (0 > expect);
    }

    @Test
    void inputStreamToStringFails() {
        Result result = IOUtils.inputStreamToString((InputStream)this.failingStream);
        Assertions.assertTrue((boolean)result.isInternalError());
    }
}

