/*
 * Decompiled with CFR 0.152.
 */
package de.kgrupp.inoksjavautils.data;

import de.kgrupp.inoksjavautils.data.MultiValueMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.function.Function;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

class MultiValueMapTest {
    private static final MyClass V1 = new MyClass(1, "V1");
    private static final MyClass V2 = new MyClass(2, "V2");
    private static final MyClass V3 = new MyClass(1, "V3");
    private static final List<MyClass> LIST = Arrays.asList(V1, V2, V3);
    private MultiValueMap<Integer, MyClass, List<MyClass>> defaultMap;

    MultiValueMapTest() {
    }

    @BeforeEach
    void setUp() {
        this.defaultMap = new MultiValueMap(ArrayList::new);
        this.defaultMap.put((Object)V1.getKey(), (Object)V1);
        this.defaultMap.put((Object)V2.getKey(), (Object)V2);
        this.defaultMap.put((Object)V3.getKey(), (Object)V3);
    }

    @Test
    void putAndGet() {
        this.assertDefaultValues(this.defaultMap);
    }

    @Test
    void listCollector() {
        MultiValueMap collectedMap = (MultiValueMap)LIST.stream().collect(MultiValueMap.listCollector(MyClass::getKey, Function.identity()));
        this.assertDefaultValues((MultiValueMap<Integer, MyClass, List<MyClass>>)collectedMap);
    }

    @Test
    void collector() {
        MultiValueMap collectedMap = (MultiValueMap)LIST.stream().collect(MultiValueMap.collector(MyClass::getKey, Function.identity(), () -> this.defaultMap));
        Assertions.assertEquals((int)4, (int)((List)collectedMap.get((Object)1)).size());
        Assertions.assertEquals((int)2, (int)((List)collectedMap.get((Object)2)).size());
        Assertions.assertEquals((int)0, (int)((List)collectedMap.get((Object)3)).size());
    }

    @Test
    void collectorForParallelStream() {
        MultiValueMap collectedMap = (MultiValueMap)LIST.parallelStream().collect(MultiValueMap.collector(MyClass::getKey, Function.identity(), () -> new MultiValueMap(ArrayList::new)));
        this.assertDefaultValues((MultiValueMap<Integer, MyClass, List<MyClass>>)collectedMap);
    }

    private void assertDefaultValues(MultiValueMap<Integer, MyClass, List<MyClass>> map) {
        List result1 = (List)map.get((Object)1);
        Assertions.assertEquals((int)2, (int)result1.size());
        Assertions.assertTrue((boolean)result1.contains(V1));
        Assertions.assertTrue((boolean)result1.contains(V3));
        List result2 = (List)map.get((Object)2);
        Assertions.assertEquals((int)1, (int)result2.size());
        Assertions.assertTrue((boolean)result2.contains(V2));
        Assertions.assertTrue((boolean)((List)map.get((Object)3)).isEmpty());
    }

    private static class MyClass {
        private int key;
        private String value;

        public int getKey() {
            return this.key;
        }

        public String getValue() {
            return this.value;
        }

        public void setKey(int key) {
            this.key = key;
        }

        public void setValue(String value) {
            this.value = value;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof MyClass)) {
                return false;
            }
            MyClass other = (MyClass)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (this.getKey() != other.getKey()) {
                return false;
            }
            String this$value = this.getValue();
            String other$value = other.getValue();
            return !(this$value == null ? other$value != null : !this$value.equals(other$value));
        }

        protected boolean canEqual(Object other) {
            return other instanceof MyClass;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            result = result * 59 + this.getKey();
            String $value = this.getValue();
            result = result * 59 + ($value == null ? 43 : $value.hashCode());
            return result;
        }

        public String toString() {
            return "MultiValueMapTest.MyClass(key=" + this.getKey() + ", value=" + this.getValue() + ")";
        }

        public MyClass(int key, String value) {
            this.key = key;
            this.value = value;
        }
    }
}

