/*
 * Decompiled with CFR 0.152.
 */
package de.kevcodez.pubg.client;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.datatype.jsr310.JavaTimeModule;
import com.fasterxml.jackson.module.kotlin.KotlinModule;
import de.kevcodez.pubg.client.PlayerFilter;
import de.kevcodez.pubg.exception.ApiException;
import de.kevcodez.pubg.model.Platform;
import de.kevcodez.pubg.model.match.MatchResponse;
import de.kevcodez.pubg.model.player.PlayerResponse;
import de.kevcodez.pubg.model.player.PlayersResponse;
import de.kevcodez.pubg.model.season.PlayerSeasonResponse;
import de.kevcodez.pubg.model.season.SeasonResponse;
import de.kevcodez.pubg.model.telemetry.events.TelemetryEvent;
import de.kevcodez.pubg.model.tournament.TournamentResponse;
import de.kevcodez.pubg.model.tournament.TournamentsResponse;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import okhttp3.HttpUrl;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.Response;
import okhttp3.ResponseBody;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000\u0086\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 -2\u00020\u0001:\u0001-B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0010\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0002J\u0016\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0003J\"\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00032\n\b\u0002\u0010\u0014\u001a\u0004\u0018\u00010\u0003J\u0016\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0017\u001a\u00020\u0018J\u001e\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u001b\u001a\u00020\u00032\u0006\u0010\u001c\u001a\u00020\u0003J\u000e\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u000f\u001a\u00020\u0010J\u0014\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020!0 2\u0006\u0010\"\u001a\u00020\u0003J\u000e\u0010#\u001a\u00020$2\u0006\u0010\u0011\u001a\u00020\u0003J\u0006\u0010%\u001a\u00020&J\u0006\u0010'\u001a\u00020(J\u0010\u0010)\u001a\u00020*2\u0006\u0010+\u001a\u00020,H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006."}, d2={"Lde/kevcodez/pubg/client/ApiClient;", "", "apiKey", "", "httpClient", "Lokhttp3/OkHttpClient;", "(Ljava/lang/String;Lokhttp3/OkHttpClient;)V", "objectMapper", "Lcom/fasterxml/jackson/databind/ObjectMapper;", "buildRequest", "Lokhttp3/Request;", "url", "Lokhttp3/HttpUrl;", "getMatch", "Lde/kevcodez/pubg/model/match/MatchResponse;", "platform", "Lde/kevcodez/pubg/model/Platform;", "id", "getPlayer", "Lde/kevcodez/pubg/model/player/PlayerResponse;", "season", "getPlayers", "Lde/kevcodez/pubg/model/player/PlayersResponse;", "playerFilter", "Lde/kevcodez/pubg/client/PlayerFilter;", "getSeason", "Lde/kevcodez/pubg/model/season/PlayerSeasonResponse;", "accountId", "seasonId", "getSeasons", "Lde/kevcodez/pubg/model/season/SeasonResponse;", "getTelemetryData", "", "Lde/kevcodez/pubg/model/telemetry/events/TelemetryEvent;", "URL", "getTournament", "Lde/kevcodez/pubg/model/tournament/TournamentResponse;", "getTournaments", "Lde/kevcodez/pubg/model/tournament/TournamentsResponse;", "isStatusOk", "", "validateResponse", "", "response", "Lokhttp3/Response;", "Companion", "pubg-api-wrapper"})
public final class ApiClient {
    private final ObjectMapper objectMapper;
    private final String apiKey;
    private final OkHttpClient httpClient;
    private static final String API_SCHEME = "https";
    private static final String API_HOST = "api.playbattlegrounds.com";
    public static final Companion Companion = new Companion(null);

    @NotNull
    public final PlayerResponse getPlayer(@NotNull Platform platform, @NotNull String id, @Nullable String season) {
        Response response;
        Intrinsics.checkParameterIsNotNull((Object)((Object)platform), (String)"platform");
        Intrinsics.checkParameterIsNotNull((Object)id, (String)"id");
        HttpUrl.Builder urlBuilder = new HttpUrl.Builder().scheme(API_SCHEME).host(API_HOST).addPathSegment("shards").addPathSegment(platform.getIdentifier()).addPathSegment("players").addPathSegment(id);
        if (season != null) {
            urlBuilder = urlBuilder.addPathSegment("seasons").addPathSegment(season);
        }
        HttpUrl httpUrl = urlBuilder.build();
        Intrinsics.checkExpressionValueIsNotNull((Object)httpUrl, (String)"urlBuilder.build()");
        Request request = this.buildRequest(httpUrl);
        Response response2 = response = this.httpClient.newCall(request).execute();
        Intrinsics.checkExpressionValueIsNotNull((Object)response2, (String)"response");
        this.validateResponse(response2);
        ResponseBody responseBody = response.body();
        if (responseBody == null) {
            Intrinsics.throwNpe();
        }
        Object object = this.objectMapper.readValue(responseBody.string(), PlayerResponse.class);
        Intrinsics.checkExpressionValueIsNotNull((Object)object, (String)"objectMapper.readValue(r\u2026ayerResponse::class.java)");
        return (PlayerResponse)object;
    }

    @NotNull
    public static /* synthetic */ PlayerResponse getPlayer$default(ApiClient apiClient, Platform platform, String string, String string2, int n, Object object) {
        if ((n & 4) != 0) {
            string2 = null;
        }
        return apiClient.getPlayer(platform, string, string2);
    }

    @NotNull
    public final PlayersResponse getPlayers(@NotNull Platform platform, @NotNull PlayerFilter playerFilter) {
        Response response;
        Object playerIds;
        Intrinsics.checkParameterIsNotNull((Object)((Object)platform), (String)"platform");
        Intrinsics.checkParameterIsNotNull((Object)playerFilter, (String)"playerFilter");
        HttpUrl.Builder urlBuilder = new HttpUrl.Builder().scheme(API_SCHEME).host(API_HOST).addPathSegment("shards").addPathSegment(platform.getIdentifier()).addPathSegment("players");
        Collection collection = playerFilter.getPlayerIds();
        if (!collection.isEmpty()) {
            playerIds = CollectionsKt.joinToString$default((Iterable)playerFilter.getPlayerIds(), (CharSequence)",", null, null, (int)0, null, null, (int)62, null);
            urlBuilder = urlBuilder.addEncodedQueryParameter("filter[playerIds]", (String)playerIds);
        }
        if (!(playerIds = (Collection)playerFilter.getPlayerNames()).isEmpty()) {
            String playerNames = CollectionsKt.joinToString$default((Iterable)playerFilter.getPlayerNames(), (CharSequence)",", null, null, (int)0, null, null, (int)62, null);
            urlBuilder = urlBuilder.addEncodedQueryParameter("filter[playerNames]", playerNames);
        }
        HttpUrl httpUrl = urlBuilder.build();
        Intrinsics.checkExpressionValueIsNotNull((Object)httpUrl, (String)"urlBuilder.build()");
        Request request = this.buildRequest(httpUrl);
        Response response2 = response = this.httpClient.newCall(request).execute();
        Intrinsics.checkExpressionValueIsNotNull((Object)response2, (String)"response");
        this.validateResponse(response2);
        ResponseBody responseBody = response.body();
        if (responseBody == null) {
            Intrinsics.throwNpe();
        }
        String bodyAsString = responseBody.string();
        Object object = this.objectMapper.readValue(bodyAsString, PlayersResponse.class);
        Intrinsics.checkExpressionValueIsNotNull((Object)object, (String)"objectMapper.readValue(b\u2026yersResponse::class.java)");
        return (PlayersResponse)object;
    }

    @NotNull
    public final MatchResponse getMatch(@NotNull Platform platform, @NotNull String id) {
        Response response;
        Intrinsics.checkParameterIsNotNull((Object)((Object)platform), (String)"platform");
        Intrinsics.checkParameterIsNotNull((Object)id, (String)"id");
        HttpUrl.Builder urlBuilder = new HttpUrl.Builder().scheme(API_SCHEME).host(API_HOST).addPathSegment("shards").addPathSegment(platform.getIdentifier()).addPathSegment("matches").addPathSegment(id);
        HttpUrl httpUrl = urlBuilder.build();
        Intrinsics.checkExpressionValueIsNotNull((Object)httpUrl, (String)"urlBuilder.build()");
        Request request = this.buildRequest(httpUrl);
        Response response2 = response = this.httpClient.newCall(request).execute();
        Intrinsics.checkExpressionValueIsNotNull((Object)response2, (String)"response");
        this.validateResponse(response2);
        ResponseBody responseBody = response.body();
        if (responseBody == null) {
            Intrinsics.throwNpe();
        }
        String bodyAsString = responseBody.string();
        Object object = this.objectMapper.readValue(bodyAsString, MatchResponse.class);
        Intrinsics.checkExpressionValueIsNotNull((Object)object, (String)"objectMapper.readValue(b\u2026atchResponse::class.java)");
        return (MatchResponse)object;
    }

    @NotNull
    public final List<TelemetryEvent> getTelemetryData(@NotNull String URL) {
        Response response;
        Intrinsics.checkParameterIsNotNull((Object)URL, (String)"URL");
        HttpUrl httpUrl = HttpUrl.parse((String)URL);
        if (httpUrl == null) {
            Intrinsics.throwNpe();
        }
        Intrinsics.checkExpressionValueIsNotNull((Object)httpUrl, (String)"HttpUrl.parse(URL)!!");
        HttpUrl httpUrl2 = httpUrl;
        Request request = this.buildRequest(httpUrl2);
        Response response2 = response = this.httpClient.newCall(request).execute();
        Intrinsics.checkExpressionValueIsNotNull((Object)response2, (String)"response");
        this.validateResponse(response2);
        ResponseBody responseBody = response.body();
        if (responseBody == null) {
            Intrinsics.throwNpe();
        }
        Object object = this.objectMapper.readValue(responseBody.string(), (TypeReference)new TypeReference<List<? extends TelemetryEvent>>(){});
        Intrinsics.checkExpressionValueIsNotNull((Object)object, (String)"objectMapper.readValue(r\u2026st<TelemetryEvent>>() {})");
        return (List)object;
    }

    @NotNull
    public final SeasonResponse getSeasons(@NotNull Platform platform) {
        Response response;
        Intrinsics.checkParameterIsNotNull((Object)((Object)platform), (String)"platform");
        HttpUrl.Builder urlBuilder = new HttpUrl.Builder().scheme(API_SCHEME).host(API_HOST).addPathSegment("shards").addPathSegment(platform.getIdentifier()).addPathSegment("seasons");
        HttpUrl httpUrl = urlBuilder.build();
        Intrinsics.checkExpressionValueIsNotNull((Object)httpUrl, (String)"urlBuilder.build()");
        Request request = this.buildRequest(httpUrl);
        Response response2 = response = this.httpClient.newCall(request).execute();
        Intrinsics.checkExpressionValueIsNotNull((Object)response2, (String)"response");
        this.validateResponse(response2);
        ResponseBody responseBody = response.body();
        if (responseBody == null) {
            Intrinsics.throwNpe();
        }
        String bodyAsString = responseBody.string();
        Object object = this.objectMapper.readValue(bodyAsString, SeasonResponse.class);
        Intrinsics.checkExpressionValueIsNotNull((Object)object, (String)"objectMapper.readValue(b\u2026asonResponse::class.java)");
        return (SeasonResponse)object;
    }

    @NotNull
    public final PlayerSeasonResponse getSeason(@NotNull Platform platform, @NotNull String accountId, @NotNull String seasonId) {
        Response response;
        Intrinsics.checkParameterIsNotNull((Object)((Object)platform), (String)"platform");
        Intrinsics.checkParameterIsNotNull((Object)accountId, (String)"accountId");
        Intrinsics.checkParameterIsNotNull((Object)seasonId, (String)"seasonId");
        HttpUrl.Builder urlBuilder = new HttpUrl.Builder().scheme(API_SCHEME).host(API_HOST).addPathSegment("shards").addPathSegment(platform.getIdentifier()).addPathSegment("players").addPathSegment(accountId).addPathSegment("seasons").addPathSegment(seasonId);
        HttpUrl httpUrl = urlBuilder.build();
        Intrinsics.checkExpressionValueIsNotNull((Object)httpUrl, (String)"urlBuilder.build()");
        Request request = this.buildRequest(httpUrl);
        Response response2 = response = this.httpClient.newCall(request).execute();
        Intrinsics.checkExpressionValueIsNotNull((Object)response2, (String)"response");
        this.validateResponse(response2);
        ResponseBody responseBody = response.body();
        if (responseBody == null) {
            Intrinsics.throwNpe();
        }
        String bodyAsString = responseBody.string();
        Object object = this.objectMapper.readValue(bodyAsString, PlayerSeasonResponse.class);
        Intrinsics.checkExpressionValueIsNotNull((Object)object, (String)"objectMapper.readValue(b\u2026asonResponse::class.java)");
        return (PlayerSeasonResponse)object;
    }

    @NotNull
    public final TournamentsResponse getTournaments() {
        Response response;
        HttpUrl.Builder urlBuilder = new HttpUrl.Builder().scheme(API_SCHEME).host(API_HOST).addPathSegment("tournments");
        HttpUrl httpUrl = urlBuilder.build();
        Intrinsics.checkExpressionValueIsNotNull((Object)httpUrl, (String)"urlBuilder.build()");
        Request request = this.buildRequest(httpUrl);
        Response response2 = response = this.httpClient.newCall(request).execute();
        Intrinsics.checkExpressionValueIsNotNull((Object)response2, (String)"response");
        this.validateResponse(response2);
        ResponseBody responseBody = response.body();
        if (responseBody == null) {
            Intrinsics.throwNpe();
        }
        String bodyAsString = responseBody.string();
        Object object = this.objectMapper.readValue(bodyAsString, TournamentsResponse.class);
        Intrinsics.checkExpressionValueIsNotNull((Object)object, (String)"objectMapper.readValue(b\u2026entsResponse::class.java)");
        return (TournamentsResponse)object;
    }

    @NotNull
    public final TournamentResponse getTournament(@NotNull String id) {
        Response response;
        Intrinsics.checkParameterIsNotNull((Object)id, (String)"id");
        HttpUrl.Builder urlBuilder = new HttpUrl.Builder().scheme(API_SCHEME).host(API_HOST).addPathSegment("tournments").addPathSegment(id);
        HttpUrl httpUrl = urlBuilder.build();
        Intrinsics.checkExpressionValueIsNotNull((Object)httpUrl, (String)"urlBuilder.build()");
        Request request = this.buildRequest(httpUrl);
        Response response2 = response = this.httpClient.newCall(request).execute();
        Intrinsics.checkExpressionValueIsNotNull((Object)response2, (String)"response");
        this.validateResponse(response2);
        ResponseBody responseBody = response.body();
        if (responseBody == null) {
            Intrinsics.throwNpe();
        }
        String bodyAsString = responseBody.string();
        Object object = this.objectMapper.readValue(bodyAsString, TournamentResponse.class);
        Intrinsics.checkExpressionValueIsNotNull((Object)object, (String)"objectMapper.readValue(b\u2026mentResponse::class.java)");
        return (TournamentResponse)object;
    }

    public final boolean isStatusOk() {
        Response response;
        HttpUrl.Builder urlBuilder = new HttpUrl.Builder().scheme(API_SCHEME).host(API_HOST).addPathSegment("status");
        HttpUrl httpUrl = urlBuilder.build();
        Intrinsics.checkExpressionValueIsNotNull((Object)httpUrl, (String)"urlBuilder.build()");
        Request request = this.buildRequest(httpUrl);
        Response response2 = response = this.httpClient.newCall(request).execute();
        Intrinsics.checkExpressionValueIsNotNull((Object)response2, (String)"response");
        return response2.isSuccessful();
    }

    private final Request buildRequest(HttpUrl url) {
        Request request = new Request.Builder().url(url).addHeader("Authorization", "Bearer " + this.apiKey).addHeader("Accept", "application/vnd.api+json").build();
        Intrinsics.checkExpressionValueIsNotNull((Object)request, (String)"Request.Builder()\n      \u2026on\")\n            .build()");
        return request;
    }

    private final void validateResponse(Response response) {
        if (!response.isSuccessful()) {
            throw (Throwable)new ApiException(response);
        }
    }

    public ApiClient(@NotNull String apiKey, @NotNull OkHttpClient httpClient) {
        Intrinsics.checkParameterIsNotNull((Object)apiKey, (String)"apiKey");
        Intrinsics.checkParameterIsNotNull((Object)httpClient, (String)"httpClient");
        this.apiKey = apiKey;
        this.httpClient = httpClient;
        ObjectMapper objectMapper = new ObjectMapper().registerModule((Module)new KotlinModule(0, false, false, 7, null)).registerModule((Module)new JavaTimeModule()).enable(DeserializationFeature.ACCEPT_EMPTY_STRING_AS_NULL_OBJECT);
        Intrinsics.checkExpressionValueIsNotNull((Object)objectMapper, (String)"ObjectMapper()\n        .\u2026TY_STRING_AS_NULL_OBJECT)");
        this.objectMapper = objectMapper;
    }

    @Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lde/kevcodez/pubg/client/ApiClient$Companion;", "", "()V", "API_HOST", "", "API_SCHEME", "pubg-api-wrapper"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

