/*
 * Decompiled with CFR 0.152.
 */
package de.kevcodez.amazon.stock.parser;

import java.io.ByteArrayInputStream;
import java.math.BigDecimal;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Optional;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpression;
import javax.xml.xpath.XPathFactory;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.w3c.dom.Document;
import org.w3c.dom.NodeList;

@Metadata(mv={1, 1, 10}, bv={1, 0, 2}, k=1, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000 \u00102\u00020\u0001:\u0001\u0010B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0016\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00012\u0006\u0010\u0006\u001a\u00020\u0007J\u001c\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\t2\u0006\u0010\u0005\u001a\u00020\u00012\u0006\u0010\u0006\u001a\u00020\u0007J\u001c\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\n0\t2\u0006\u0010\u0005\u001a\u00020\u00012\u0006\u0010\u0006\u001a\u00020\u0007J\u0018\u0010\f\u001a\u0004\u0018\u00010\u00072\u0006\u0010\u0005\u001a\u00020\u00012\u0006\u0010\u0006\u001a\u00020\u0007J\u000e\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0007\u00a8\u0006\u0011"}, d2={"Lde/kevcodez/amazon/stock/parser/XmlParser;", "", "()V", "evaluateNodeList", "Lorg/w3c/dom/NodeList;", "document", "xpathExpression", "", "evaluateNumber", "Ljava/util/Optional;", "Ljava/math/BigDecimal;", "evaluatePrice", "evaluateString", "parseString", "Lorg/w3c/dom/Document;", "stringToParse", "Companion", "stock"})
public final class XmlParser {
    private static final XPathFactory xPathfactory;
    private static final DocumentBuilderFactory factory;
    private static final BigDecimal ONE_HUNDRED;
    public static final Companion Companion;

    @NotNull
    public final Document parseString(@NotNull String stringToParse) {
        ByteArrayInputStream byteArrayInputStream;
        Intrinsics.checkParameterIsNotNull((Object)stringToParse, (String)"stringToParse");
        DocumentBuilder builder = factory.newDocumentBuilder();
        String string = stringToParse;
        Charset charset = StandardCharsets.UTF_8;
        Intrinsics.checkExpressionValueIsNotNull((Object)charset, (String)"StandardCharsets.UTF_8");
        Charset charset2 = charset;
        ByteArrayInputStream byteArrayInputStream2 = byteArrayInputStream;
        ByteArrayInputStream byteArrayInputStream3 = byteArrayInputStream;
        DocumentBuilder documentBuilder = builder;
        byte[] byArray = string.getBytes(charset2);
        Intrinsics.checkExpressionValueIsNotNull((Object)byArray, (String)"(this as java.lang.String).getBytes(charset)");
        byte[] byArray2 = byArray;
        byteArrayInputStream2(byArray2);
        Document document = documentBuilder.parse(byteArrayInputStream3);
        Intrinsics.checkExpressionValueIsNotNull((Object)document, (String)"builder.parse(ByteArrayI\u2026StandardCharsets.UTF_8)))");
        return document;
    }

    @NotNull
    public final Optional<BigDecimal> evaluateNumber(@NotNull Object document, @NotNull String xpathExpression) {
        Optional<BigDecimal> optional;
        CharSequence charSequence;
        Intrinsics.checkParameterIsNotNull((Object)document, (String)"document");
        Intrinsics.checkParameterIsNotNull((Object)xpathExpression, (String)"xpathExpression");
        XPath xpath = xPathfactory.newXPath();
        XPathExpression expr = xpath.compile(xpathExpression);
        Object evalutedObject = expr.evaluate(document, XPathConstants.NUMBER);
        if (evalutedObject == null || (charSequence = (CharSequence)evalutedObject.toString()).length() == 0 || Intrinsics.areEqual((Object)evalutedObject.toString(), (Object)"NaN")) {
            Optional<BigDecimal> optional2 = Optional.empty();
            optional = optional2;
            Intrinsics.checkExpressionValueIsNotNull(optional2, (String)"Optional.empty()");
        } else {
            Optional<BigDecimal> optional3 = Optional.of(new BigDecimal(evalutedObject.toString()));
            optional = optional3;
            Intrinsics.checkExpressionValueIsNotNull(optional3, (String)"Optional.of(BigDecimal(evalutedObject.toString()))");
        }
        return optional;
    }

    @NotNull
    public final Optional<BigDecimal> evaluatePrice(@NotNull Object document, @NotNull String xpathExpression) {
        Optional<BigDecimal> optional;
        Intrinsics.checkParameterIsNotNull((Object)document, (String)"document");
        Intrinsics.checkParameterIsNotNull((Object)xpathExpression, (String)"xpathExpression");
        Optional<BigDecimal> number = this.evaluateNumber(document, xpathExpression);
        if (number.isPresent()) {
            Optional<BigDecimal> optional2 = Optional.of(number.get().divide(ONE_HUNDRED));
            optional = optional2;
            Intrinsics.checkExpressionValueIsNotNull(optional2, (String)"Optional.of(number.get().divide(ONE_HUNDRED))");
        } else {
            Optional<BigDecimal> optional3 = Optional.empty();
            optional = optional3;
            Intrinsics.checkExpressionValueIsNotNull(optional3, (String)"Optional.empty()");
        }
        return optional;
    }

    @Nullable
    public final String evaluateString(@NotNull Object document, @NotNull String xpathExpression) {
        Intrinsics.checkParameterIsNotNull((Object)document, (String)"document");
        Intrinsics.checkParameterIsNotNull((Object)xpathExpression, (String)"xpathExpression");
        XPath xpath = xPathfactory.newXPath();
        XPathExpression expr = xpath.compile(xpathExpression);
        return (String)expr.evaluate(document, XPathConstants.STRING);
    }

    @NotNull
    public final NodeList evaluateNodeList(@NotNull Object document, @NotNull String xpathExpression) {
        Intrinsics.checkParameterIsNotNull((Object)document, (String)"document");
        Intrinsics.checkParameterIsNotNull((Object)xpathExpression, (String)"xpathExpression");
        XPath xpath = xPathfactory.newXPath();
        XPathExpression expr = xpath.compile(xpathExpression);
        Object object = expr.evaluate(document, XPathConstants.NODESET);
        if (object == null) {
            throw new TypeCastException("null cannot be cast to non-null type org.w3c.dom.NodeList");
        }
        return (NodeList)object;
    }

    static {
        Companion = new Companion(null);
        xPathfactory = XPathFactory.newInstance();
        factory = DocumentBuilderFactory.newInstance();
        ONE_HUNDRED = new BigDecimal(100L);
    }

    @Metadata(mv={1, 1, 10}, bv={1, 0, 2}, k=1, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0005\u001a\n \u0007*\u0004\u0018\u00010\u00060\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\b\u001a\n \u0007*\u0004\u0018\u00010\t0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\n"}, d2={"Lde/kevcodez/amazon/stock/parser/XmlParser$Companion;", "", "()V", "ONE_HUNDRED", "Ljava/math/BigDecimal;", "factory", "Ljavax/xml/parsers/DocumentBuilderFactory;", "kotlin.jvm.PlatformType", "xPathfactory", "Ljavax/xml/xpath/XPathFactory;", "stock"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

