/*
 * Decompiled with CFR 0.152.
 */
package de.kevcodez.amazon.stock.api;

import de.kevcodez.amazon.stock.api.SignedRequestHelper;
import de.kevcodez.amazon.stock.config.AmazonConfig;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.util.Base64;
import java.util.Map;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.function.Function;
import javax.crypto.Mac;
import javax.crypto.spec.SecretKeySpec;
import javax.ws.rs.client.Client;
import javax.ws.rs.client.ClientBuilder;
import javax.ws.rs.client.WebTarget;
import javax.ws.rs.core.Response;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 10}, bv={1, 0, 2}, k=1, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010%\n\u0002\b\u0005\u0018\u0000 \u001a2\u00020\u0001:\u0001\u001aB\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u001c\u0010\r\u001a\u00020\u00062\u0012\u0010\u000e\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00060\u000fH\u0002J\u0018\u0010\u0010\u001a\u00020\u00062\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u0011\u001a\u00020\u0006H\u0002J\b\u0010\u0012\u001a\u00020\u0013H\u0002J\u001a\u0010\u0014\u001a\u00020\u00062\u0012\u0010\u0015\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00060\u0016J\u001c\u0010\u0017\u001a\u00020\u00062\u0012\u0010\u0015\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00060\u0016H\u0002J\u0010\u0010\u0018\u001a\u00020\u00062\u0006\u0010\u0019\u001a\u00020\u0006H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0005\u001a\u00020\u00068BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0007\u0010\bR\u0010\u0010\t\u001a\u0004\u0018\u00010\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000b\u001a\u0004\u0018\u00010\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001b"}, d2={"Lde/kevcodez/amazon/stock/api/SignedRequestHelper;", "", "amazonConfig", "Lde/kevcodez/amazon/stock/config/AmazonConfig;", "(Lde/kevcodez/amazon/stock/config/AmazonConfig;)V", "currentTimestampAsString", "", "getCurrentTimestampAsString", "()Ljava/lang/String;", "mac", "Ljavax/crypto/Mac;", "secretKeySpec", "Ljavax/crypto/spec/SecretKeySpec;", "canonicalize", "sortedParamMap", "Ljava/util/SortedMap;", "hmac", "stringToSign", "initSecurity", "", "readRequest", "params", "", "sign", "urlEncodeUTF8", "s", "Companion", "stock"})
public final class SignedRequestHelper {
    private SecretKeySpec secretKeySpec;
    private Mac mac;
    private final AmazonConfig amazonConfig;
    private static final String HMAC_SHA256_ALGORITHM = "HmacSHA256";
    private static final String REQUEST_URI = "/onca/xml";
    private static final String REQUEST_METHOD = "GET";
    private static final DateTimeFormatter DATE_TIME_FORMATTER;
    public static final Companion Companion;

    private final String getCurrentTimestampAsString() {
        ZonedDateTime zonedDateTime = ZonedDateTime.now(ZoneId.of("Z"));
        String string = zonedDateTime.format(DATE_TIME_FORMATTER);
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"zonedDateTime.format(DATE_TIME_FORMATTER)");
        return string;
    }

    private final void initSecurity() {
        String string = this.amazonConfig.getSecretKey();
        Charset charset = StandardCharsets.UTF_8;
        Intrinsics.checkExpressionValueIsNotNull((Object)charset, (String)"StandardCharsets.UTF_8");
        Charset charset2 = charset;
        String string2 = string;
        if (string2 == null) {
            throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
        }
        byte[] byArray = string2.getBytes(charset2);
        Intrinsics.checkExpressionValueIsNotNull((Object)byArray, (String)"(this as java.lang.String).getBytes(charset)");
        byte[] secretyKeyBytes = byArray;
        this.secretKeySpec = new SecretKeySpec(secretyKeyBytes, HMAC_SHA256_ALGORITHM);
        Mac mac = this.mac = Mac.getInstance(HMAC_SHA256_ALGORITHM);
        if (mac == null) {
            Intrinsics.throwNpe();
        }
        mac.init(this.secretKeySpec);
    }

    @NotNull
    public final String readRequest(@NotNull Map<String, String> params) {
        Intrinsics.checkParameterIsNotNull(params, (String)"params");
        String requestUrl = this.sign(params);
        Client client = ClientBuilder.newBuilder().build();
        WebTarget target = client.target(requestUrl);
        Response response = target.request().get();
        Object object = response.readEntity(String.class);
        Intrinsics.checkExpressionValueIsNotNull((Object)object, (String)"response.readEntity(String::class.java)");
        return (String)object;
    }

    private final String sign(Map<String, String> params) {
        Map<String, String> map = params;
        String string = "AWSAccessKeyId";
        String string2 = this.amazonConfig.getAccessKeyId();
        map.put(string, string2);
        map = params;
        string = "AssociateTag";
        string2 = this.amazonConfig.getAssociateTag();
        map.put(string, string2);
        map = params;
        string = "Timestamp";
        string2 = this.getCurrentTimestampAsString();
        map.put(string, string2);
        TreeMap<String, String> sortedParamMap = new TreeMap<String, String>(params);
        String canonicalQS = this.canonicalize((SortedMap<String, String>)sortedParamMap);
        String toSign = "GET\n" + this.amazonConfig.getEndpoint() + "\n/onca/xml\n" + canonicalQS;
        Mac mac = this.mac;
        if (mac == null) {
            Intrinsics.throwNpe();
        }
        String hmac = this.hmac(mac, toSign);
        String sig = this.urlEncodeUTF8(hmac);
        return "http://" + this.amazonConfig.getEndpoint() + "/onca/xml?" + canonicalQS + "&Signature=" + sig;
    }

    private final String hmac(Mac mac, String stringToSign) {
        String string = stringToSign;
        Charset charset = StandardCharsets.UTF_8;
        Intrinsics.checkExpressionValueIsNotNull((Object)charset, (String)"StandardCharsets.UTF_8");
        Charset charset2 = charset;
        String string2 = string;
        if (string2 == null) {
            throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
        }
        byte[] byArray = string2.getBytes(charset2);
        Intrinsics.checkExpressionValueIsNotNull((Object)byArray, (String)"(this as java.lang.String).getBytes(charset)");
        byte[] data = byArray;
        byte[] rawHmac = mac.doFinal(data);
        Base64.Encoder encoder = Base64.getEncoder();
        byte[] byArray2 = encoder.encode(rawHmac);
        Intrinsics.checkExpressionValueIsNotNull((Object)byArray2, (String)"encoder.encode(rawHmac)");
        byte[] byArray3 = byArray2;
        Charset charset3 = StandardCharsets.UTF_8;
        Intrinsics.checkExpressionValueIsNotNull((Object)charset3, (String)"StandardCharsets.UTF_8");
        Charset charset4 = charset3;
        return new String(byArray3, charset4);
    }

    private final String canonicalize(SortedMap<String, String> sortedParamMap) {
        String string = sortedParamMap.entrySet().stream().map(new Function<T, R>(this){
            final /* synthetic */ SignedRequestHelper this$0;

            @NotNull
            public final String apply(Map.Entry<String, String> p) {
                StringBuilder stringBuilder = new StringBuilder();
                String string = p.getKey();
                Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"p.key");
                StringBuilder stringBuilder2 = stringBuilder.append(SignedRequestHelper.access$urlEncodeUTF8(this.this$0, string)).append("=");
                String string2 = p.getValue();
                Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"p.value");
                return stringBuilder2.append(SignedRequestHelper.access$urlEncodeUTF8(this.this$0, string2)).toString();
            }
            {
                this.this$0 = signedRequestHelper;
            }
        }).reduce(canonicalize.2.INSTANCE).orElse("");
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"sortedParamMap.entries.s\u2026}\n            .orElse(\"\")");
        return string;
    }

    private final String urlEncodeUTF8(String s) {
        try {
            String string = URLEncoder.encode(s, StandardCharsets.UTF_8.name());
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"URLEncoder.encode(s, Sta\u2026ardCharsets.UTF_8.name())");
            return string;
        }
        catch (UnsupportedEncodingException e) {
            throw (Throwable)new UnsupportedOperationException(e);
        }
    }

    public SignedRequestHelper(@NotNull AmazonConfig amazonConfig) {
        Intrinsics.checkParameterIsNotNull((Object)amazonConfig, (String)"amazonConfig");
        this.amazonConfig = amazonConfig;
        this.initSecurity();
    }

    static {
        Companion = new Companion(null);
        DATE_TIME_FORMATTER = DateTimeFormatter.ofPattern("yyyy-MM-dd'T'HH:mm:ss'Z'");
    }

    @NotNull
    public static final /* synthetic */ String access$urlEncodeUTF8(SignedRequestHelper $this, @NotNull String s) {
        return $this.urlEncodeUTF8(s);
    }

    @Metadata(mv={1, 1, 10}, bv={1, 0, 2}, k=1, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0016\u0010\u0003\u001a\n \u0005*\u0004\u0018\u00010\u00040\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0007X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0007X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\n"}, d2={"Lde/kevcodez/amazon/stock/api/SignedRequestHelper$Companion;", "", "()V", "DATE_TIME_FORMATTER", "Ljava/time/format/DateTimeFormatter;", "kotlin.jvm.PlatformType", "HMAC_SHA256_ALGORITHM", "", "REQUEST_METHOD", "REQUEST_URI", "stock"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

