/*
 * Decompiled with CFR 0.152.
 */
package de.kevcodez.amazon.stock;

import de.kevcodez.amazon.stock.Stock;
import de.kevcodez.amazon.stock.api.CartCreate;
import de.kevcodez.amazon.stock.api.SignedRequestHelper;
import de.kevcodez.amazon.stock.config.AmazonConfig;
import de.kevcodez.amazon.stock.exception.AmazonStockException;
import de.kevcodez.amazon.stock.parser.XmlParser;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.StringCompanionObject;
import org.jetbrains.annotations.NotNull;
import org.w3c.dom.Document;
import org.w3c.dom.NodeList;

@Metadata(mv={1, 1, 10}, bv={1, 0, 2}, k=1, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\u0010 \n\u0002\b\u0002\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u000e\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010J\u001a\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000e0\u00112\f\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00100\u0011R\u001a\u0010\u0005\u001a\u00020\u0006X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0007\u0010\b\"\u0004\b\t\u0010\nR\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Lde/kevcodez/amazon/stock/StockService;", "", "amazonConfig", "Lde/kevcodez/amazon/stock/config/AmazonConfig;", "(Lde/kevcodez/amazon/stock/config/AmazonConfig;)V", "cartCreate", "Lde/kevcodez/amazon/stock/api/CartCreate;", "getCartCreate", "()Lde/kevcodez/amazon/stock/api/CartCreate;", "setCartCreate", "(Lde/kevcodez/amazon/stock/api/CartCreate;)V", "xmlParser", "Lde/kevcodez/amazon/stock/parser/XmlParser;", "getStock", "Lde/kevcodez/amazon/stock/Stock;", "amazonId", "", "", "amazonIds", "stock"})
public final class StockService {
    @NotNull
    private CartCreate cartCreate;
    private final XmlParser xmlParser;

    @NotNull
    public final CartCreate getCartCreate() {
        return this.cartCreate;
    }

    public final void setCartCreate(@NotNull CartCreate cartCreate) {
        Intrinsics.checkParameterIsNotNull((Object)cartCreate, (String)"<set-?>");
        this.cartCreate = cartCreate;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<Stock> getStock(@NotNull List<String> amazonIds) {
        Intrinsics.checkParameterIsNotNull(amazonIds, (String)"amazonIds");
        String cartResponse = this.cartCreate.createCart(amazonIds);
        Document document = this.xmlParser.parseString(cartResponse);
        NodeList cartItems = this.xmlParser.evaluateNodeList(document, "//CartItem");
        String errorCode = this.xmlParser.evaluateString(document, "//Error/Code");
        if (errorCode != null && Intrinsics.areEqual((Object)"AWS.ECommerceService.InvalidQuantity", (Object)errorCode) ^ true) {
            throw (Throwable)new AmazonStockException("Error occured while getting stock information: " + errorCode);
        }
        ArrayList<Stock> stockInformation = new ArrayList<Stock>();
        int n = 0;
        int n2 = cartItems.getLength();
        while (n < n2) {
            String string;
            BigDecimal bigDecimal;
            String baseXpath;
            void i;
            StringCompanionObject stringCompanionObject = StringCompanionObject.INSTANCE;
            String string2 = "//CartItem[%d]/";
            Object[] objectArray = new Object[]{(int)(i + true)};
            Intrinsics.checkExpressionValueIsNotNull((Object)String.format(string2, Arrays.copyOf(objectArray, objectArray.length)), (String)"java.lang.String.format(format, *args)");
            Optional<BigDecimal> price = this.xmlParser.evaluatePrice(document, baseXpath + "Price/Amount");
            String amazonId = this.xmlParser.evaluateString(document, baseXpath + "ASIN");
            int stock = this.xmlParser.evaluateNumber(document, baseXpath + "Quantity").get().intValue();
            if (amazonId == null) {
                Intrinsics.throwNpe();
            }
            Intrinsics.checkExpressionValueIsNotNull((Object)price.get(), (String)"price.get()");
            int n3 = stock;
            stockInformation.add(new Stock(bigDecimal, n3, string));
            ++i;
        }
        return stockInformation;
    }

    @NotNull
    public final Stock getStock(@NotNull String amazonId) {
        Intrinsics.checkParameterIsNotNull((Object)amazonId, (String)"amazonId");
        return this.getStock(CollectionsKt.listOf((Object)amazonId)).get(0);
    }

    public StockService(@NotNull AmazonConfig amazonConfig) {
        Intrinsics.checkParameterIsNotNull((Object)amazonConfig, (String)"amazonConfig");
        SignedRequestHelper signedRequestHelper = new SignedRequestHelper(amazonConfig);
        this.cartCreate = new CartCreate(signedRequestHelper);
        this.xmlParser = new XmlParser();
    }
}

