/*
 * Decompiled with CFR 0.152.
 */
package de.kaufhof.pillar.cli;

import com.datastax.driver.core.AuthProvider;
import com.datastax.driver.core.Cluster;
import com.datastax.driver.core.ConsistencyLevel;
import com.datastax.driver.core.QueryOptions;
import com.datastax.driver.core.Session;
import com.typesafe.config.Config;
import de.kaufhof.pillar.Registry;
import de.kaufhof.pillar.Registry$;
import de.kaufhof.pillar.ReplicationStrategy;
import de.kaufhof.pillar.ReplicationStrategyBuilder$;
import de.kaufhof.pillar.Reporter;
import de.kaufhof.pillar.cli.App$;
import de.kaufhof.pillar.cli.Command;
import de.kaufhof.pillar.cli.CommandExecutor$;
import de.kaufhof.pillar.cli.CommandLineConfiguration;
import de.kaufhof.pillar.cli.CommandLineConfiguration$;
import de.kaufhof.pillar.cli.Initialize$;
import de.kaufhof.pillar.cli.MigratorAction;
import de.kaufhof.pillar.config.ConnectionConfiguration;
import de.kaufhof.pillar.config.SslConfig;
import java.io.File;
import scala.Function1;
import scala.Serializable;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;

@ScalaSignature(bytes="\u0006\u0001I<Q!\u0001\u0002\t\u0002-\t1!\u00119q\u0015\t\u0019A!A\u0002dY&T!!\u0002\u0004\u0002\rALG\u000e\\1s\u0015\t9\u0001\"A\u0004lCV4\u0007n\u001c4\u000b\u0003%\t!\u0001Z3\u0004\u0001A\u0011A\"D\u0007\u0002\u0005\u0019)aB\u0001E\u0001\u001f\t\u0019\u0011\t\u001d9\u0014\u00055\u0001\u0002CA\t\u0015\u001b\u0005\u0011\"\"A\n\u0002\u000bM\u001c\u0017\r\\1\n\u0005U\u0011\"AB!osJ+g\rC\u0003\u0018\u001b\u0011\u0005\u0001$\u0001\u0004=S:LGO\u0010\u000b\u0002\u0017!)!$\u0004C\u00017\u0005)\u0011\r\u001d9msR\u0019Ad\u0017/\u0011\u00051ib\u0001\u0002\b\u0003\u0001y\u0019\"!\b\t\t\u0011\u0001j\"\u0011!Q\u0001\n\u0005\n\u0001B]3q_J$XM\u001d\t\u0003E\rj\u0011\u0001B\u0005\u0003I\u0011\u0011\u0001BU3q_J$XM\u001d\u0005\tMu\u0011\t\u0011)A\u0005O\u0005i1m\u001c8gS\u001e,(/\u0019;j_:\u0004\"\u0001K\u0018\u000e\u0003%R!AK\u0016\u0002\r\r|gNZ5h\u0015\taS&\u0001\u0005usB,7/\u00194f\u0015\u0005q\u0013aA2p[&\u0011\u0001'\u000b\u0002\u0007\u0007>tg-[4\t\u000b]iB\u0011\u0001\u001a\u0015\u0007q\u0019D\u0007C\u0003!c\u0001\u0007\u0011\u0005C\u0003'c\u0001\u0007q\u0005C\u00037;\u0011\u0005q'A\u0002sk:$\"\u0001O\u001e\u0011\u0005EI\u0014B\u0001\u001e\u0013\u0005\u0011)f.\u001b;\t\u000bq*\u0004\u0019A\u001f\u0002\u0013\u0005\u0014x-^7f]R\u001c\bcA\t?\u0001&\u0011qH\u0005\u0002\u0006\u0003J\u0014\u0018-\u001f\t\u0003\u0003\u0012s!!\u0005\"\n\u0005\r\u0013\u0012A\u0002)sK\u0012,g-\u0003\u0002F\r\n11\u000b\u001e:j]\u001eT!a\u0011\n\t\u000b!kB\u0011B%\u0002\u001b\r\u0014X-\u0019;f\u00072,8\u000f^3s)\tQE\u000b\u0005\u0002L%6\tAJ\u0003\u0002N\u001d\u0006!1m\u001c:f\u0015\ty\u0005+\u0001\u0004ee&4XM\u001d\u0006\u0003#6\n\u0001\u0002Z1uCN$\u0018\r_\u0005\u0003'2\u0013qa\u00117vgR,'\u000fC\u0003V\u000f\u0002\u0007a+A\fd_:tWm\u0019;j_:\u001cuN\u001c4jOV\u0014\u0018\r^5p]B\u0011q+W\u0007\u00021*\u0011!\u0006B\u0005\u00035b\u0013qcQ8o]\u0016\u001cG/[8o\u0007>tg-[4ve\u0006$\u0018n\u001c8\t\u000f\u0001J\u0002\u0013!a\u0001C!9a%\u0007I\u0001\u0002\u00049\u0003\"\u00020\u000e\t\u0003y\u0016\u0001B7bS:$\"\u0001\u000f1\t\u000bqj\u0006\u0019A\u001f\t\u000f\tl\u0011\u0013!C\u0001G\u0006y\u0011\r\u001d9ms\u0012\"WMZ1vYR$\u0013'F\u0001eU\t\tSmK\u0001g!\t9G.D\u0001i\u0015\tI'.A\u0005v]\u000eDWmY6fI*\u00111NE\u0001\u000bC:tw\u000e^1uS>t\u0017BA7i\u0005E)hn\u00195fG.,GMV1sS\u0006t7-\u001a\u0005\b_6\t\n\u0011\"\u0001q\u0003=\t\u0007\u000f\u001d7zI\u0011,g-Y;mi\u0012\u0012T#A9+\u0005\u001d*\u0007")
public class App {
    private final Reporter reporter;
    private final Config configuration;

    public static Config apply$default$2() {
        return App$.MODULE$.apply$default$2();
    }

    public static Reporter apply$default$1() {
        return App$.MODULE$.apply$default$1();
    }

    public static void main(String[] stringArray) {
        App$.MODULE$.main(stringArray);
    }

    public static App apply(Reporter reporter, Config config) {
        return App$.MODULE$.apply(reporter, config);
    }

    /*
     * WARNING - void declaration
     */
    public void run(String[] arguments) {
        CommandLineConfiguration commandLineConfiguration = CommandLineConfiguration$.MODULE$.buildFromArguments(arguments);
        Registry registry = Registry$.MODULE$.fromDirectory(new File(commandLineConfiguration.migrationsDirectory(), commandLineConfiguration.dataStore()), this.reporter);
        String dataStoreName = commandLineConfiguration.dataStore();
        String environment = commandLineConfiguration.environment();
        ConnectionConfiguration cassandraConfiguration = new ConnectionConfiguration(dataStoreName, environment, this.configuration);
        Cluster cluster = this.createCluster(cassandraConfiguration);
        MigratorAction migratorAction = commandLineConfiguration.command();
        Session session = Initialize$.MODULE$.equals(migratorAction) ? cluster.connect() : cluster.connect(cassandraConfiguration.keyspace());
        Session session2 = session;
        ReplicationStrategy replicationOptions = ReplicationStrategyBuilder$.MODULE$.getReplicationStrategy(this.configuration, dataStoreName, environment);
        Command command = new Command(commandLineConfiguration.command(), session2, cassandraConfiguration.keyspace(), commandLineConfiguration.timeStampOption(), registry, replicationOptions);
        try {
            CommandExecutor$.MODULE$.apply().execute(command, this.reporter);
        }
        catch (Throwable throwable) {
            void var8_10;
            var8_10.close();
            throw throwable;
        }
        session2.close();
    }

    private Cluster createCluster(ConnectionConfiguration connectionConfiguration) {
        QueryOptions queryOptions = new QueryOptions();
        queryOptions.setConsistencyLevel(ConsistencyLevel.QUORUM);
        Cluster.Builder clusterBuilder = Cluster.builder().addContactPoint(connectionConfiguration.seedAddress()).withPort(connectionConfiguration.port()).withQueryOptions(queryOptions);
        connectionConfiguration.auth().foreach((Function1)new Serializable(this, clusterBuilder){
            public static final long serialVersionUID = 0L;
            private final Cluster.Builder clusterBuilder$1;

            public final Cluster.Builder apply(AuthProvider x$1) {
                return this.clusterBuilder$1.withAuthProvider(x$1);
            }
            {
                this.clusterBuilder$1 = clusterBuilder$1;
            }
        });
        connectionConfiguration.sslConfig().foreach((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final void apply(SslConfig x$1) {
                x$1.setAsSystemProperties();
            }
        });
        Object object = connectionConfiguration.useSsl() ? clusterBuilder.withSSL() : BoxedUnit.UNIT;
        return clusterBuilder.build();
    }

    public App(Reporter reporter, Config configuration) {
        this.reporter = reporter;
        this.configuration = configuration;
    }
}

