/*
 * Decompiled with CFR 0.152.
 */
package de.kaufhof.pillar.cli;

import com.datastax.driver.core.AuthProvider;
import com.datastax.driver.core.Cluster;
import com.datastax.driver.core.Session;
import com.typesafe.config.Config;
import com.typesafe.config.ConfigFactory;
import de.kaufhof.pillar.Registry;
import de.kaufhof.pillar.Registry$;
import de.kaufhof.pillar.Reporter;
import de.kaufhof.pillar.cli.App$;
import de.kaufhof.pillar.cli.Command;
import de.kaufhof.pillar.cli.CommandExecutor$;
import de.kaufhof.pillar.cli.CommandLineConfiguration;
import de.kaufhof.pillar.cli.CommandLineConfiguration$;
import de.kaufhof.pillar.cli.Initialize$;
import de.kaufhof.pillar.cli.MigratorAction;
import de.kaufhof.pillar.config.ConnectionConfiguration;
import de.kaufhof.pillar.config.SslConfig;
import java.io.File;
import scala.Function1;
import scala.Serializable;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;

@ScalaSignature(bytes="\u0006\u0001=<Q!\u0001\u0002\t\u0002-\t1!\u00119q\u0015\t\u0019A!A\u0002dY&T!!\u0002\u0004\u0002\rALG\u000e\\1s\u0015\t9\u0001\"A\u0004lCV4\u0007n\u001c4\u000b\u0003%\t!\u0001Z3\u0004\u0001A\u0011A\"D\u0007\u0002\u0005\u0019)aB\u0001E\u0001\u001f\t\u0019\u0011\t\u001d9\u0014\u00055\u0001\u0002CA\t\u0015\u001b\u0005\u0011\"\"A\n\u0002\u000bM\u001c\u0017\r\\1\n\u0005U\u0011\"AB!osJ+g\rC\u0003\u0018\u001b\u0011\u0005\u0001$\u0001\u0004=S:LGO\u0010\u000b\u0002\u0017!)!$\u0004C\u00017\u0005)\u0011\r\u001d9msR\u0011A$\u0018\t\u0003\u0019u1AA\u0004\u0002\u0001=M\u0011Q\u0004\u0005\u0005\tAu\u0011\t\u0011)A\u0005C\u0005A!/\u001a9peR,'\u000f\u0005\u0002#G5\tA!\u0003\u0002%\t\tA!+\u001a9peR,'\u000fC\u0003\u0018;\u0011\u0005a\u0005\u0006\u0002\u001dO!)\u0001%\na\u0001C!9\u0011&\bb\u0001\n\u0013Q\u0013!D2p]\u001aLw-\u001e:bi&|g.F\u0001,!\ta3'D\u0001.\u0015\tqs&\u0001\u0004d_:4\u0017n\u001a\u0006\u0003aE\n\u0001\u0002^=qKN\fg-\u001a\u0006\u0002e\u0005\u00191m\\7\n\u0005Qj#AB\"p]\u001aLw\r\u0003\u00047;\u0001\u0006IaK\u0001\u000fG>tg-[4ve\u0006$\u0018n\u001c8!\u0011\u0015AT\u0004\"\u0001:\u0003\r\u0011XO\u001c\u000b\u0003uu\u0002\"!E\u001e\n\u0005q\u0012\"\u0001B+oSRDQAP\u001cA\u0002}\n\u0011\"\u0019:hk6,g\u000e^:\u0011\u0007E\u0001%)\u0003\u0002B%\t)\u0011I\u001d:bsB\u00111I\u0012\b\u0003#\u0011K!!\u0012\n\u0002\rA\u0013X\rZ3g\u0013\t9\u0005J\u0001\u0004TiJLgn\u001a\u0006\u0003\u000bJAQAS\u000f\u0005\n-\u000bQb\u0019:fCR,7\t\\;ti\u0016\u0014HC\u0001'W!\tiE+D\u0001O\u0015\ty\u0005+\u0001\u0003d_J,'BA)S\u0003\u0019!'/\u001b<fe*\u00111+M\u0001\tI\u0006$\u0018m\u001d;bq&\u0011QK\u0014\u0002\b\u00072,8\u000f^3s\u0011\u00159\u0016\n1\u0001Y\u0003]\u0019wN\u001c8fGRLwN\\\"p]\u001aLw-\u001e:bi&|g\u000e\u0005\u0002Z76\t!L\u0003\u0002/\t%\u0011AL\u0017\u0002\u0018\u0007>tg.Z2uS>t7i\u001c8gS\u001e,(/\u0019;j_:Dq\u0001I\r\u0011\u0002\u0003\u0007\u0011\u0005C\u0003`\u001b\u0011\u0005\u0001-\u0001\u0003nC&tGC\u0001\u001eb\u0011\u0015qd\f1\u0001@\u0011\u001d\u0019W\"%A\u0005\u0002\u0011\fq\"\u00199qYf$C-\u001a4bk2$H%M\u000b\u0002K*\u0012\u0011EZ\u0016\u0002OB\u0011\u0001.\\\u0007\u0002S*\u0011!n[\u0001\nk:\u001c\u0007.Z2lK\u0012T!\u0001\u001c\n\u0002\u0015\u0005tgn\u001c;bi&|g.\u0003\u0002oS\n\tRO\\2iK\u000e\\W\r\u001a,be&\fgnY3")
public class App {
    private final Reporter reporter;
    private final Config configuration;

    public static Reporter apply$default$1() {
        return App$.MODULE$.apply$default$1();
    }

    public static void main(String[] stringArray) {
        App$.MODULE$.main(stringArray);
    }

    public static App apply(Reporter reporter) {
        return App$.MODULE$.apply(reporter);
    }

    private Config configuration() {
        return this.configuration;
    }

    /*
     * WARNING - void declaration
     */
    public void run(String[] arguments) {
        CommandLineConfiguration commandLineConfiguration = CommandLineConfiguration$.MODULE$.buildFromArguments(arguments);
        Registry registry = Registry$.MODULE$.fromDirectory(new File(commandLineConfiguration.migrationsDirectory(), commandLineConfiguration.dataStore()));
        String dataStoreName = commandLineConfiguration.dataStore();
        String environment = commandLineConfiguration.environment();
        ConnectionConfiguration cassandraConfiguration = new ConnectionConfiguration(dataStoreName, environment, this.configuration());
        Cluster cluster = this.createCluster(cassandraConfiguration);
        MigratorAction migratorAction = commandLineConfiguration.command();
        Session session = Initialize$.MODULE$.equals(migratorAction) ? cluster.connect() : cluster.connect(cassandraConfiguration.keyspace());
        Session session2 = session;
        Command command = new Command(commandLineConfiguration.command(), session2, cassandraConfiguration.keyspace(), commandLineConfiguration.timeStampOption(), registry);
        try {
            CommandExecutor$.MODULE$.apply().execute(command, this.reporter);
        }
        catch (Throwable throwable) {
            void var8_10;
            var8_10.close();
            throw throwable;
        }
        session2.close();
    }

    private Cluster createCluster(ConnectionConfiguration connectionConfiguration) {
        Cluster.Builder clusterBuilder = Cluster.builder().addContactPoint(connectionConfiguration.seedAddress()).withPort(connectionConfiguration.port());
        connectionConfiguration.auth().foreach((Function1)new Serializable(this, clusterBuilder){
            public static final long serialVersionUID = 0L;
            private final Cluster.Builder clusterBuilder$1;

            public final Cluster.Builder apply(AuthProvider x$1) {
                return this.clusterBuilder$1.withAuthProvider(x$1);
            }
            {
                this.clusterBuilder$1 = clusterBuilder$1;
            }
        });
        connectionConfiguration.sslConfig().foreach((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final void apply(SslConfig x$1) {
                x$1.setAsSystemProperties();
            }
        });
        Object object = connectionConfiguration.useSsl() ? clusterBuilder.withSSL() : BoxedUnit.UNIT;
        return clusterBuilder.build();
    }

    public App(Reporter reporter) {
        this.reporter = reporter;
        this.configuration = ConfigFactory.load();
    }
}

