/*
 * Decompiled with CFR 0.152.
 */
package de.kaleidox.vban.packet;

import de.kaleidox.util.model.Builder;
import de.kaleidox.util.model.ByteArray;
import de.kaleidox.vban.Util;
import de.kaleidox.vban.VBAN;
import de.kaleidox.vban.exception.InvalidPacketAttributeException;
import de.kaleidox.vban.model.UnfinishedByteArray;
import de.kaleidox.vban.packet.VBANPacketHead;

public class VBANPacket<T>
implements ByteArray {
    public static final int MAX_SIZE = 1436;
    public static final int MAX_SIZE_WITHOUT_HEAD = 1408;
    protected final UnfinishedByteArray unfinishedByteArray;
    protected VBANPacketHead<T> head;
    private boolean hasData = false;

    private VBANPacket(VBANPacketHead<T> head) {
        this.head = head;
        this.unfinishedByteArray = new UnfinishedByteArray(1436, true);
        this.unfinishedByteArray.append(head.getBytes());
    }

    public VBANPacket(VBANPacketHead<T> head, byte[] data) {
        this.head = head;
        this.unfinishedByteArray = new UnfinishedByteArray(1436);
        this.unfinishedByteArray.append(head.getBytes());
        this.attachData(data);
    }

    public VBANPacket<T> setData(byte[] data) throws IllegalStateException, IllegalArgumentException {
        if (this.hasData) {
            throw new IllegalStateException("Packet already has data attached");
        }
        this.attachData(data);
        return this;
    }

    @Override
    public byte[] getBytes() {
        return this.unfinishedByteArray.getBytes();
    }

    private void attachData(byte[] data) throws IllegalArgumentException {
        if (data.length > 1436) {
            throw new IllegalArgumentException("Data is too large to be sent, must be smaller than 1436");
        }
        this.unfinishedByteArray.append(data);
        this.hasData = true;
    }

    public static Decoded decode(byte[] bytes) throws InvalidPacketAttributeException {
        return new Decoded(bytes);
    }

    public static class Factory<T>
    implements de.kaleidox.util.model.Factory<VBANPacket<T>> {
        private final VBANPacketHead.Factory<T> headFactory;

        private Factory(VBANPacketHead.Factory<T> headFactory) {
            this.headFactory = headFactory;
        }

        @Override
        public VBANPacket<T> create() {
            return new VBANPacket((VBANPacketHead)this.headFactory.create());
        }

        @Override
        public int counter() {
            return this.headFactory.counter();
        }

        public static <T> Builder<T> builder(VBAN.Protocol<T> protocol) {
            return new Builder(protocol);
        }

        public static <T> Factory<T> protocolDefault(VBAN.Protocol<T> protocol) {
            return Factory.builder(protocol).setDefaultFactory().build();
        }

        public static class Builder<T>
        implements de.kaleidox.util.model.Builder<Factory<T>> {
            private final VBAN.Protocol<T> protocol;
            private VBANPacketHead.Factory<T> headFactory;

            private Builder(VBAN.Protocol<T> protocol) {
                this.protocol = protocol;
                this.setDefaultFactory();
            }

            public Builder<T> setDefaultFactory() {
                return this.setHeadFactory(VBANPacketHead.defaultFactory(this.protocol));
            }

            public VBANPacketHead.Factory getHeadFactory() {
                return this.headFactory;
            }

            public Builder<T> setHeadFactory(VBANPacketHead.Factory<T> headFactory) {
                this.headFactory = headFactory;
                return this;
            }

            @Override
            public Factory<T> build() {
                return new Factory(this.headFactory);
            }
        }
    }

    public static class Decoded
    extends VBANPacket {
        public Decoded(byte[] bytes) throws InvalidPacketAttributeException {
            super(VBANPacketHead.decode(Util.subArray(bytes, 0, 28)), Util.subArray(bytes, 29, 1436));
        }

        public VBANPacketHead.Decoded getHead() {
            if (this.head instanceof VBANPacketHead.Decoded) {
                return (VBANPacketHead.Decoded)this.head;
            }
            throw new AssertionError((Object)"Head is not instanceof VBANPacketHead.Decoded");
        }
    }
}

