/*
 * Decompiled with CFR 0.152.
 */
package de.kaleidox.vban.model;

import de.kaleidox.util.model.ByteArray;
import java.util.Objects;

public class UnfinishedByteArray
implements ByteArray {
    private final boolean fixedSize;
    private byte[] buf;
    private int cursor;

    public UnfinishedByteArray(int initSize) {
        this(initSize, false);
    }

    public UnfinishedByteArray(int initSize, boolean fixedSize) {
        this.buf = new byte[initSize];
        this.fixedSize = fixedSize;
    }

    public void append(byte ... bytes) throws ArrayIndexOutOfBoundsException {
        Objects.requireNonNull(bytes, "bytearray is null");
        int newSize = this.cursor + bytes.length;
        if (newSize > this.buf.length) {
            if (this.fixedSize) {
                throw new ArrayIndexOutOfBoundsException("Cannot append more elements, array is at fixed size");
            }
            byte[] newBuf = new byte[this.buf.length * 2 + bytes.length];
            System.arraycopy(this.buf, 0, newBuf, 0, this.buf.length);
            this.buf = newBuf;
        }
        for (byte aByte : bytes) {
            this.buf[this.cursor++] = aByte;
        }
    }

    public int length() {
        return this.cursor;
    }

    public byte[] finish() {
        byte[] finished = new byte[this.length()];
        System.arraycopy(this.buf, 0, finished, 0, finished.length);
        return finished;
    }

    @Override
    public byte[] getBytes() {
        return this.finish();
    }

    public int getBufferSize() {
        return this.buf.length;
    }

    public byte[] getBufferArray() {
        return this.buf;
    }
}

