/*
 * Decompiled with CFR 0.152.
 */
package de.kaleidox.vban;

import de.kaleidox.vban.VBAN;
import de.kaleidox.vban.packet.VBANPacket;
import java.io.IOException;
import java.io.InputStream;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.SocketException;

public class VBANInputStream<T>
extends InputStream {
    private final VBAN.Protocol<T> expectedProtocol;
    private final InetAddress address;
    private final int port;
    private DatagramSocket socket;
    private byte[] buf = new byte[0];
    private int iBuf = 0;
    private boolean closed = false;

    public VBANInputStream(VBAN.Protocol<T> expectedProtocol, InetAddress address, int port) throws SocketException {
        this.expectedProtocol = expectedProtocol;
        this.address = address;
        this.port = port;
        InetSocketAddress socketAddress = new InetSocketAddress(address, port);
        this.socket = new DatagramSocket(socketAddress);
    }

    public void setSocketTimeout(int ms) throws SocketException {
        this.socket.setSoTimeout(ms);
    }

    public synchronized T readData() throws IOException {
        VBANPacket.Decoded packet = this.readPacket();
        VBAN.Protocol<?> rcvProt = packet.getHead().getProtocol();
        if (!rcvProt.equals(this.expectedProtocol)) {
            throw new IllegalStateException("Expected Protocol mismatches received protocol [exp:" + this.expectedProtocol + ";rcv:" + rcvProt + "]");
        }
        return this.expectedProtocol.createDataObject(packet.getBytes());
    }

    public synchronized VBANPacket.Decoded readPacket() throws IOException {
        long skipped;
        long available = this.available();
        if (available != (skipped = this.skip(available))) {
            throw new AssertionError((Object)("Didn't skip as many bytes as available [ava=" + available + ";skp=" + skipped + "]"));
        }
        byte[] bytes = new byte[1436];
        int nRead = this.read(bytes);
        return VBANPacket.decode(bytes);
    }

    @Override
    public synchronized int read() throws IOException {
        if (this.closed) {
            throw new IOException("Stream is closed");
        }
        if (this.buf.length == 0 || this.iBuf >= this.buf.length) {
            if (this.socket.isClosed()) {
                throw new SocketException("Socket is closed");
            }
            if (!this.socket.isBound()) {
                throw new SocketException("Socket is not bound");
            }
            byte[] bytes = new byte[1436];
            DatagramPacket packet = new DatagramPacket(bytes, bytes.length);
            this.socket.receive(packet);
            this.buf = bytes;
            this.iBuf = 0;
        }
        return this.buf[this.iBuf++];
    }

    @Override
    public int available() {
        return this.buf.length - this.iBuf;
    }

    @Override
    public void close() {
        this.socket.close();
        this.socket = null;
        this.closed = true;
    }
}

