/*
 * Decompiled with CFR 0.152.
 */
package de.kaleidox.vban.packet;

import de.kaleidox.util.model.Builder;
import de.kaleidox.util.model.ByteArray;
import de.kaleidox.vban.Util;
import de.kaleidox.vban.VBAN;
import de.kaleidox.vban.exception.InvalidPacketAttributeException;
import de.kaleidox.vban.model.DataRateValue;
import de.kaleidox.vban.model.FormatValue;
import de.kaleidox.vban.model.UnfinishedByteArray;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;

public class VBANPacketHead<T>
implements ByteArray {
    public static final int SIZE = 28;
    private final UnfinishedByteArray unfinishedByteArray;

    private VBANPacketHead(byte[] bytes) {
        this.unfinishedByteArray = new UnfinishedByteArray(28);
        this.unfinishedByteArray.append(bytes);
    }

    private VBANPacketHead(int protocol, int sampleRateIndex, int samples, int channel, int format, int codec, String streamName, int frameCounter) {
        Util.checkRange(samples, 0, 255);
        Util.checkRange(channel, 0, 255);
        this.unfinishedByteArray = new UnfinishedByteArray(28);
        this.unfinishedByteArray.append("VBAN".getBytes());
        this.unfinishedByteArray.append((byte)(protocol | sampleRateIndex));
        this.unfinishedByteArray.append((byte)samples, (byte)channel);
        this.unfinishedByteArray.append((byte)(format | codec));
        this.unfinishedByteArray.append(Util.trimArray(Util.stringToBytesASCII(streamName), 16));
        this.unfinishedByteArray.append(Util.intToByteArray(frameCounter, 4));
    }

    @Override
    public byte[] getBytes() {
        return this.unfinishedByteArray.getBytes();
    }

    public static <T> Factory<T> defaultFactory(VBAN.Protocol<T> forProtocol) throws UnsupportedOperationException {
        return Factory.builder(forProtocol).build();
    }

    public static Decoded decode(byte[] headBytes) throws InvalidPacketAttributeException {
        return new Decoded(headBytes);
    }

    public static class Factory<T>
    implements de.kaleidox.util.model.Factory<VBANPacketHead<T>> {
        private final int protocol;
        private final int sampleRate;
        private final int samples;
        private final int channel;
        private final int format;
        private final int codec;
        private final String streamName;
        private int counter;

        private Factory(VBAN.Protocol<T> protocol, DataRateValue<? super T> sampleRate, int samples, int channel, FormatValue<? super T> format, int codec, String streamName) {
            this.protocol = protocol.getValue();
            this.sampleRate = sampleRate.getValue();
            this.samples = samples;
            this.channel = channel;
            this.format = format.getValue();
            this.codec = codec;
            this.streamName = streamName;
            this.counter = 0;
        }

        @Override
        public synchronized VBANPacketHead<T> create() {
            return new VBANPacketHead(this.protocol, this.sampleRate, this.samples, this.channel, this.format, this.codec, this.streamName, this.counter++);
        }

        @Override
        public synchronized int counter() {
            return this.counter;
        }

        public static <T> Builder<T> builder(VBAN.Protocol<T> protocol) throws UnsupportedOperationException {
            return new Builder(protocol);
        }

        public static class Builder<T>
        implements de.kaleidox.util.model.Builder<Factory<T>> {
            private final VBAN.Protocol<T> protocol;
            private DataRateValue<? super T> sampleRate;
            private int samples;
            private int channel;
            private FormatValue<? super T> format;
            private int codec = 0;
            private String streamName = null;

            private Builder(VBAN.Protocol<T> protocol) throws UnsupportedOperationException {
                this.protocol = protocol;
                switch (protocol.getValue()) {
                    case 0: {
                        this.sampleRate = VBAN.SampleRate.Hz48000;
                        this.samples = 255;
                        this.channel = 2;
                        this.format = VBAN.AudioFormat.INT16;
                        this.streamName = "Stream1";
                        return;
                    }
                    case 32: {
                        this.streamName = "MIDI1";
                        break;
                    }
                    case 64: {
                        this.sampleRate = VBAN.BitsPerSecond.Bps256000;
                        this.samples = 0;
                        this.channel = 0;
                        this.format = VBAN.Format.BYTE8;
                        if (this.streamName == null) {
                            this.streamName = "Command1";
                        }
                        return;
                    }
                    case 96: {
                        break;
                    }
                    default: {
                        throw new AssertionError((Object)("Unknown Protocol: " + protocol));
                    }
                }
                throw new UnsupportedOperationException("Unsupported Protocol: " + protocol);
            }

            public VBAN.Protocol<T> getProtocol() {
                return this.protocol;
            }

            public DataRateValue<? super T> getSampleRate() {
                return this.sampleRate;
            }

            public Builder<T> setSRValue(DataRateValue<? super T> sampleRate) {
                this.sampleRate = sampleRate;
                return this;
            }

            public int getSamples() {
                return this.samples;
            }

            public Builder<T> setSamples(byte samples) {
                this.samples = samples - 1;
                return this;
            }

            public int getChannel() {
                return this.channel;
            }

            public Builder<T> setChannel(byte channel) {
                this.channel = channel - 1;
                return this;
            }

            public FormatValue<? super T> getFormat() {
                return this.format;
            }

            public Builder<T> setFormatValue(FormatValue<? super T> format) {
                this.format = format;
                return this;
            }

            public int getCodec() {
                return this.codec;
            }

            public Builder<T> setCodec(int codec) {
                this.codec = codec;
                return this;
            }

            public String getStreamName() {
                return this.streamName;
            }

            public Builder<T> setStreamName(String streamName) {
                this.streamName = streamName;
                return this;
            }

            @Override
            public Factory<T> build() {
                assert (this.protocol != null) : "No protocol defined!";
                return new Factory(this.protocol, this.sampleRate, this.samples, this.channel, this.format, this.codec, this.streamName);
            }
        }
    }

    public static class Decoded
    extends VBANPacketHead {
        private final VBAN.Protocol<?> protocol;
        private final DataRateValue<?> dataRateValue;
        private final int samples;
        private final int channel;
        private final FormatValue<?> format;
        private final int codec;
        private final String streamName;
        private final int frame;

        private Decoded(byte[] bytes) throws InvalidPacketAttributeException {
            super(bytes);
            if (bytes.length > 28) {
                throw new IllegalArgumentException("Bytearray is too large, must be exactly 28 bytes long!");
            }
            if (bytes[0] != 86 || bytes[1] != 66 || bytes[2] != 65 || bytes[3] != 78) {
                throw new InvalidPacketAttributeException("Invalid packet head: First bytes must be 'VBAN' [rcv='" + new String(Util.subArray(bytes, 0, 4), StandardCharsets.US_ASCII) + "']");
            }
            int protocolInt = bytes[4] & 0xF8;
            this.protocol = VBAN.Protocol.byValue(protocolInt);
            if (this.protocol.getValue() == 96) {
                throw new IllegalStateException("Service Subprotocol is not supported!");
            }
            int dataRateInt = bytes[4] & 7;
            switch (this.protocol.getValue()) {
                case 0: {
                    this.dataRateValue = VBAN.SampleRate.byValue(dataRateInt);
                    break;
                }
                case 32: 
                case 64: {
                    this.dataRateValue = VBAN.BitsPerSecond.byValue(dataRateInt);
                    break;
                }
                default: {
                    this.dataRateValue = null;
                }
            }
            this.samples = bytes[5] + 1;
            this.channel = bytes[6] + 1;
            int formatInt = bytes[7] & 0x1F;
            switch (this.protocol.getValue()) {
                case 0: {
                    this.format = VBAN.AudioFormat.byValue(formatInt);
                    break;
                }
                case 32: {
                    this.format = VBAN.Format.byValue(formatInt);
                    break;
                }
                case 64: {
                    this.format = VBAN.CommandFormat.byValue(formatInt);
                    break;
                }
                default: {
                    this.format = null;
                }
            }
            int reservedBit = bytes[7] & 0xEF;
            int codecInt = bytes[7] & 0xF0;
            switch (codecInt) {
                case 0: 
                case 16: 
                case 32: 
                case 240: {
                    this.codec = codecInt;
                    break;
                }
                default: {
                    throw new InvalidPacketAttributeException("Invalid Codec selector: " + Integer.toHexString(codecInt));
                }
            }
            byte[] nameBytes = new byte[16];
            System.arraycopy(bytes, 8, nameBytes, 0, 16);
            this.streamName = Util.bytesToString(nameBytes, StandardCharsets.US_ASCII);
            byte[] frameBytes = new byte[4];
            System.arraycopy(bytes, 24, frameBytes, 0, 4);
            this.frame = ByteBuffer.wrap(frameBytes).asIntBuffer().get();
        }

        public VBAN.Protocol<?> getProtocol() {
            return this.protocol;
        }

        public DataRateValue<?> getDataRateValue() {
            return this.dataRateValue;
        }

        public int getSamples() {
            return this.samples;
        }

        public int getChannel() {
            return this.channel;
        }

        public FormatValue<?> getFormat() {
            return this.format;
        }

        public int getCodec() {
            return this.codec;
        }

        public String getStreamName() {
            return this.streamName;
        }
    }
}

