/*
 * Decompiled with CFR 0.152.
 */
package de.kaleidox.vban;

import de.kaleidox.util.model.Factory;
import de.kaleidox.vban.Util;
import de.kaleidox.vban.model.UnfinishedByteArray;
import de.kaleidox.vban.packet.VBANPacket;
import java.io.IOException;
import java.io.OutputStream;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.InetAddress;
import java.net.SocketException;

public class VBANOutputStream<T>
extends OutputStream {
    private final InetAddress address;
    private final int port;
    private Factory<VBANPacket<T>> packetFactory;
    private DatagramSocket socket;
    private UnfinishedByteArray buf;
    private boolean closed = false;

    public VBANOutputStream(Factory<VBANPacket<T>> packetFactory, InetAddress address, int port) throws SocketException {
        this.packetFactory = packetFactory;
        this.address = address;
        this.port = port;
        this.socket = new DatagramSocket();
        this.buf = new UnfinishedByteArray(1436, true);
    }

    public VBANOutputStream<T> sendData(T data) throws IOException, IllegalArgumentException {
        this.write(Util.createByteArray(data));
        this.flush();
        return this;
    }

    @Override
    public void write(int b) throws IOException {
        if (this.buf.length() + 1 > 1436) {
            throw new IOException("Byte array is too large, must be smaller than 1436");
        }
        this.buf.append((byte)b);
        if ((char)b == '\n') {
            this.flush();
        }
    }

    @Override
    public synchronized void flush() throws IOException {
        if (this.closed) {
            throw new IOException("Stream is closed");
        }
        if (this.buf.length() > 1436) {
            throw new IOException("Byte array is too large, must be smaller than 1436");
        }
        byte[] bytes = this.packetFactory.create().setData(this.buf.getBytes()).getBytes();
        this.socket.send(new DatagramPacket(bytes, bytes.length, this.address, this.port));
        this.buf = new UnfinishedByteArray(1436, true);
    }

    @Override
    public void close() {
        try {
            this.flush();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        this.socket.close();
        this.socket = null;
        this.packetFactory = null;
        this.closed = true;
    }
}

