/*
 * Decompiled with CFR 0.152.
 */
package de.kaleidox.vban;

import de.kaleidox.util.model.Bindable;
import de.kaleidox.util.model.Factory;
import de.kaleidox.util.model.IntEnum;
import de.kaleidox.vban.VBANInputStream;
import de.kaleidox.vban.VBANOutputStream;
import de.kaleidox.vban.model.DataRateValue;
import de.kaleidox.vban.model.FormatValue;
import de.kaleidox.vban.model.data.AudioFrame;
import de.kaleidox.vban.model.data.MIDICommand;
import de.kaleidox.vban.packet.VBANPacket;
import java.net.InetAddress;
import java.net.SocketException;
import java.nio.charset.StandardCharsets;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class VBAN {
    public static final int DEFAULT_PORT = 6980;

    private VBAN() {
    }

    public static VBANOutputStream<AudioFrame> openAudioOutputStream(int port) throws SocketException {
        return VBAN.openAudioOutputStream(InetAddress.getLoopbackAddress(), port);
    }

    public static VBANOutputStream<AudioFrame> openAudioOutputStream(InetAddress address, int port) throws SocketException {
        return VBAN.openAudioOutputStream(VBANPacket.Factory.protocolDefault(Protocol.AUDIO), address, port);
    }

    public static VBANOutputStream<AudioFrame> openAudioOutputStream(Factory<VBANPacket<AudioFrame>> packetFactory, InetAddress address, int port) throws SocketException {
        return new VBANOutputStream<AudioFrame>(packetFactory, address, port);
    }

    public static VBANOutputStream<MIDICommand> openMidiOutputStream(int port) throws SocketException {
        return VBAN.openMidiOutputStream(InetAddress.getLoopbackAddress(), port);
    }

    public static VBANOutputStream<MIDICommand> openMidiOutputStream(InetAddress address, int port) throws SocketException {
        return VBAN.openMidiOutputStream(VBANPacket.Factory.protocolDefault(Protocol.SERIAL), address, port);
    }

    public static VBANOutputStream<MIDICommand> openMidiOutputStream(Factory<VBANPacket<MIDICommand>> packetFactory, InetAddress address, int port) throws SocketException {
        return new VBANOutputStream<MIDICommand>(packetFactory, address, port);
    }

    public static VBANOutputStream<String> openCommandOutputStream(int port) throws SocketException {
        return VBAN.openCommandOutputStream(InetAddress.getLoopbackAddress(), port);
    }

    public static VBANOutputStream<String> openCommandOutputStream(InetAddress address, int port) throws SocketException {
        return VBAN.openCommandOutputStream(VBANPacket.Factory.protocolDefault(Protocol.TEXT), address, port);
    }

    public static VBANOutputStream<String> openCommandOutputStream(Factory<VBANPacket<String>> packetFactory, InetAddress address, int port) throws SocketException {
        return new VBANOutputStream<String>(packetFactory, address, port);
    }

    public static VBANInputStream<AudioFrame> openAudioInputStream(int port) throws SocketException {
        return VBAN.openAudioInputStream(InetAddress.getLoopbackAddress(), port);
    }

    public static VBANInputStream<AudioFrame> openAudioInputStream(InetAddress address, int port) throws SocketException {
        return new VBANInputStream<AudioFrame>(Protocol.AUDIO, address, port);
    }

    public static VBANInputStream<MIDICommand> openMidiInputStream(int port) throws SocketException {
        return VBAN.openMidiInputStream(InetAddress.getLoopbackAddress(), port);
    }

    public static VBANInputStream<MIDICommand> openMidiInputStream(InetAddress address, int port) throws SocketException {
        return new VBANInputStream<MIDICommand>(Protocol.SERIAL, address, port);
    }

    public static VBANInputStream<String> openCommandInputStream(int port) throws SocketException {
        return VBAN.openCommandInputStream(InetAddress.getLoopbackAddress(), port);
    }

    public static VBANInputStream<String> openCommandInputStream(InetAddress address, int port) throws SocketException {
        return new VBANInputStream<String>(Protocol.TEXT, address, port);
    }

    public static enum Format implements FormatValue<CharSequence>
    {
        BYTE8(0);

        private final int value;

        private Format(int value) {
            this.value = value;
        }

        @Override
        public int getValue() {
            return this.value;
        }

        @Override
        public <R> boolean isType(Class<R> type) {
            return Format.class.isAssignableFrom(type);
        }

        @Override
        @Nullable
        public AudioFormat asAudioFormat() {
            return null;
        }

        @Override
        @Nullable
        public CommandFormat asCommandFormat() {
            return null;
        }

        @Override
        @NotNull
        public Format asFormat() {
            return this;
        }

        public static <T> Format byValue(int value) {
            for (Format x : Format.values()) {
                if (x.value != value) continue;
                return x;
            }
            throw new AssertionError((Object)("Unknown Format value: " + Integer.toHexString(value)));
        }
    }

    public static enum CommandFormat implements FormatValue<String>
    {
        ASCII(0),
        UTF8(16),
        WCHAR(32);

        private final int value;

        private CommandFormat(int value) {
            this.value = value;
        }

        @Override
        public int getValue() {
            return this.value;
        }

        @Override
        public <R> boolean isType(Class<R> type) {
            return CommandFormat.class.isAssignableFrom(type);
        }

        @Override
        @Nullable
        public AudioFormat asAudioFormat() {
            return null;
        }

        @Override
        @NotNull
        public CommandFormat asCommandFormat() {
            return this;
        }

        @Override
        @Nullable
        public Format asFormat() {
            return null;
        }

        public static <T> CommandFormat byValue(int value) {
            for (CommandFormat x : CommandFormat.values()) {
                if (x.value != value) continue;
                return x;
            }
            throw new AssertionError((Object)("Unknown Format value: " + Integer.toHexString(value)));
        }
    }

    public static enum AudioFormat implements FormatValue<AudioFrame>
    {
        BYTE8(0),
        INT16(1),
        INT24(2),
        INT32(3),
        FLOAT32(4),
        FLOAT64(5),
        BITS12(6),
        BITS10(7);

        private final int value;

        private AudioFormat(int value) {
            this.value = value;
        }

        @Override
        public int getValue() {
            return this.value;
        }

        @Override
        public <R> boolean isType(Class<R> type) {
            return AudioFormat.class.isAssignableFrom(type);
        }

        @Override
        @NotNull
        public AudioFormat asAudioFormat() {
            return this;
        }

        @Override
        @Nullable
        public CommandFormat asCommandFormat() {
            return null;
        }

        @Override
        @Nullable
        public Format asFormat() {
            return null;
        }

        public static <T> AudioFormat byValue(int value) {
            for (AudioFormat x : AudioFormat.values()) {
                if (x.value != value) continue;
                return x;
            }
            throw new AssertionError((Object)("Unknown AudioFormat value: " + Integer.toHexString(value)));
        }
    }

    public static enum BitsPerSecond implements DataRateValue<CharSequence>
    {
        Bps0,
        Bps110,
        Bps150,
        Bps300,
        Bps600,
        Bps1200,
        Bps2400,
        Bps4800,
        Bps9600,
        Bps14400,
        Bps19200,
        Bps31250,
        Bps38400,
        Bps57600,
        Bps115200,
        Bps128000,
        Bps230400,
        Bps250000,
        Bps256000,
        Bps460800,
        Bps921600,
        Bps1000000,
        Bps1500000,
        Bps2000000,
        Bps3000000;


        @Override
        public int getValue() {
            return this.ordinal();
        }

        @Override
        public <R> boolean isType(Class<R> type) {
            return BitsPerSecond.class.isAssignableFrom(type);
        }

        @Override
        @Nullable
        public SampleRate asSampleRate() {
            return null;
        }

        @Override
        @NotNull
        public BitsPerSecond asBitsPerSecond() {
            return this;
        }

        public static BitsPerSecond byValue(int value) {
            return BitsPerSecond.values()[value];
        }
    }

    public static enum SampleRate implements DataRateValue<AudioFrame>
    {
        Hz6000,
        Hz12000,
        Hz24000,
        Hz48000,
        Hz96000,
        Hz192000,
        Hz384000,
        Hz8000,
        Hz16000,
        Hz32000,
        Hz64000,
        Hz128000,
        Hz256000,
        Hz512000,
        Hz11025,
        Hz22050,
        Hz44100,
        Hz88200,
        Hz176400,
        Hz352800,
        Hz705600;


        @Override
        public int getValue() {
            return this.ordinal();
        }

        @Override
        public <R> boolean isType(Class<R> type) {
            return SampleRate.class.isAssignableFrom(type);
        }

        @Override
        @NotNull
        public SampleRate asSampleRate() {
            return this;
        }

        @Override
        @Nullable
        public BitsPerSecond asBitsPerSecond() {
            return null;
        }

        public static SampleRate byValue(int value) {
            return SampleRate.values()[value];
        }
    }

    public static final class Codec {
        public static final int PCM = 0;
        public static final int VBCA = 16;
        public static final int VBCV = 32;
        public static final int USER = 240;
    }

    public static abstract class Protocol<T>
    implements Bindable<T>,
    IntEnum {
        public static final Protocol<AudioFrame> AUDIO = new Protocol<AudioFrame>(0){

            @Override
            public AudioFrame createDataObject(byte[] bytes) {
                return AudioFrame.fromBytes(bytes);
            }
        };
        public static final Protocol<MIDICommand> SERIAL = new Protocol<MIDICommand>(32){

            @Override
            public MIDICommand createDataObject(byte[] bytes) {
                return MIDICommand.fromBytes(bytes);
            }
        };
        public static final Protocol<String> TEXT = new Protocol<String>(64){

            @Override
            public String createDataObject(byte[] bytes) {
                return new String(bytes, StandardCharsets.US_ASCII);
            }
        };
        public static final Protocol<byte[]> SERVICE = new Protocol<byte[]>(96){

            @Override
            public byte[] createDataObject(byte[] bytes) {
                return bytes;
            }
        };
        private final int value;

        private Protocol(int value) {
            this.value = value;
        }

        public abstract T createDataObject(byte[] var1);

        public String name() {
            switch (this.value) {
                case 0: {
                    return "AUDIO";
                }
                case 32: {
                    return "SERIAL";
                }
                case 64: {
                    return "TEXT";
                }
                case 96: {
                    return "SERVICE";
                }
            }
            throw new AssertionError((Object)("Unknown protocol: " + this.toString()));
        }

        @Override
        public int getValue() {
            return this.value;
        }

        public boolean isAudio() {
            return this.value == 0;
        }

        public boolean isSerial() {
            return this.value == 32;
        }

        public boolean isText() {
            return this.value == 64;
        }

        public boolean isService() {
            return this.value == 96;
        }

        public boolean equals(Object obj) {
            if (obj instanceof Protocol) {
                return ((Protocol)obj).value == this.value;
            }
            return false;
        }

        public String toString() {
            return String.format("%s-Protocol(%s)", this.name(), Integer.toHexString(this.value));
        }

        public static Protocol<?> byValue(int value) {
            switch (value) {
                case 0: {
                    return AUDIO;
                }
                case 32: {
                    return SERIAL;
                }
                case 64: {
                    return TEXT;
                }
                case 96: {
                    return SERVICE;
                }
            }
            throw new AssertionError((Object)("Unknown protocol value: " + Integer.toHexString(value)));
        }
    }
}

