/*
 * Decompiled with CFR 0.152.
 */
package de.kaleidox.vban;

import de.kaleidox.util.model.ByteArray;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;

public class Util {
    public static byte[] stringToBytesASCII(String str) {
        if (str == null) {
            return new byte[0];
        }
        byte[] b = new byte[str.length()];
        for (int i = 0; i < b.length; ++i) {
            b[i] = (byte)str.charAt(i);
        }
        return b;
    }

    public static byte[] trimArray(byte[] base, int size) {
        byte[] bytes = new byte[size];
        System.arraycopy(base, 0, bytes, 0, base.length);
        return bytes;
    }

    public static byte[] intToByteArray(int integer, int size) {
        return ByteBuffer.allocate(size).putInt(integer).array();
    }

    public static byte[] createByteArray(Object data) {
        if (data instanceof String) {
            return ((String)data).getBytes(StandardCharsets.UTF_8);
        }
        if (data instanceof ByteArray) {
            return ((ByteArray)data).getBytes();
        }
        throw new IllegalArgumentException("Unknown Data Type! Please contact the developer.");
    }

    public static void checkRange(int check, int from, int to) throws IllegalArgumentException {
        if (check < from || check > to) {
            throw new IllegalArgumentException(String.format("Integer out of range. [%d;%d;%d]", from, check, to));
        }
    }

    public static byte[] subArray(byte[] src, int iLow, int iHigh) {
        byte[] bytes = new byte[iHigh - iLow];
        System.arraycopy(src, iLow, bytes, 0, bytes.length);
        return bytes;
    }

    public static String bytesToString(byte[] bytes, Charset charset) {
        StringBuilder str = new StringBuilder();
        for (byte b : bytes) {
            if (b == 0) break;
            str.append(charset.decode(ByteBuffer.wrap(new byte[]{b})));
        }
        return str.toString();
    }
}

