/*
 * Decompiled with CFR 0.152.
 */
package de.kaleidox.vban.packet;

import de.kaleidox.util.model.Builder;
import de.kaleidox.util.model.ByteArray;
import de.kaleidox.vban.Util;
import de.kaleidox.vban.VBAN;
import de.kaleidox.vban.model.AudioPacket;
import de.kaleidox.vban.model.FormatValue;
import de.kaleidox.vban.model.SRValue;

public class VBANPacketHead<T>
implements ByteArray {
    public static final int SIZE = 28;
    private final byte[] bytes;

    private VBANPacketHead(int protocol, int sampleRateIndex, int samples, int channel, int format, int codec, String streamName, int frameCounter) {
        byte[] bytes = new byte[]{};
        Util.checkRange(samples, 0, 255);
        Util.checkRange(channel, 0, 255);
        bytes = Util.appendByteArray(bytes, "VBAN".getBytes());
        bytes = Util.appendByteArray(bytes, (byte)(protocol | sampleRateIndex));
        bytes = Util.appendByteArray(bytes, (byte)samples, (byte)channel);
        bytes = Util.appendByteArray(bytes, (byte)(format | codec));
        bytes = Util.appendByteArray(bytes, Util.trimArray(Util.stringToBytesASCII(streamName), 16));
        this.bytes = Util.appendByteArray(bytes, Util.intToByteArray(frameCounter, 4));
    }

    @Override
    public byte[] getBytes() {
        return this.bytes;
    }

    public static <T> Factory<T> defaultFactory(VBAN.Protocol<T> forProtocol) throws UnsupportedOperationException {
        return Factory.builder(forProtocol).build();
    }

    @Deprecated
    public static Factory<AudioPacket> defaultAudioProtocolFactory(int channel) throws UnsupportedOperationException {
        return Factory.builder(VBAN.Protocol.AUDIO).build();
    }

    @Deprecated
    public static Factory<String> defaultTextProtocolFactory() {
        return Factory.builder(VBAN.Protocol.TEXT).build();
    }

    @Deprecated
    public static Factory<CharSequence> defaultSerialProtocolFactory() {
        return Factory.builder(VBAN.Protocol.SERIAL).build();
    }

    @Deprecated
    public static Factory<ByteArray> defaultServiceProtocolFactory() throws UnsupportedOperationException {
        return Factory.builder(VBAN.Protocol.SERVICE).build();
    }

    public static class Factory<T>
    implements de.kaleidox.util.model.Factory<VBANPacketHead<T>> {
        private final int protocol;
        private final int sampleRate;
        private final int samples;
        private final int channel;
        private final int format;
        private final int codec;
        private final String streamName;
        private int counter;

        private Factory(VBAN.Protocol<T> protocol, SRValue<T> sampleRate, int samples, int channel, FormatValue<T> format, int codec, String streamName) {
            this.protocol = protocol.getValue();
            this.sampleRate = sampleRate.getValue();
            this.samples = samples;
            this.channel = channel;
            this.format = format.getValue();
            this.codec = codec;
            this.streamName = streamName;
            this.counter = 0;
        }

        @Override
        public synchronized VBANPacketHead<T> create() {
            return new VBANPacketHead(this.protocol, this.sampleRate, this.samples, this.channel, this.format, this.codec, this.streamName, this.counter++);
        }

        @Override
        public synchronized int counter() {
            return this.counter;
        }

        public static <T> Builder<T> builder(VBAN.Protocol<T> protocol) throws UnsupportedOperationException {
            return new Builder(protocol);
        }

        public static class Builder<T>
        implements de.kaleidox.util.model.Builder<Factory<T>> {
            private final VBAN.Protocol<T> protocol;
            private SRValue<T> sampleRate;
            private int samples;
            private int channel;
            private FormatValue<T> format;
            private int codec = 0;
            private String streamName = null;

            private Builder(VBAN.Protocol<T> protocol) throws UnsupportedOperationException {
                this.protocol = protocol;
                switch (protocol.getValue()) {
                    case 0: {
                        this.sampleRate = VBAN.SampleRate.Hz48000;
                        this.samples = 255;
                        this.channel = 2;
                        this.format = VBAN.AudioFormat.INT16;
                        this.streamName = "Stream1";
                        break;
                    }
                    case 32: {
                        this.streamName = "MIDI1";
                        break;
                    }
                    case 64: {
                        this.sampleRate = VBAN.BitsPerSecond.Bps256000;
                        this.samples = 0;
                        this.channel = 0;
                        this.format = VBAN.Format.BYTE8;
                        if (this.streamName == null) {
                            this.streamName = "Command1";
                        }
                        return;
                    }
                    case 96: {
                        break;
                    }
                    default: {
                        throw new AssertionError((Object)("Unknown Protocol: " + protocol));
                    }
                }
                throw new UnsupportedOperationException("Unsupported Protocol: " + protocol);
            }

            public VBAN.Protocol<T> getProtocol() {
                return this.protocol;
            }

            public SRValue<T> getSampleRate() {
                return this.sampleRate;
            }

            public Builder setSRValue(SRValue<T> sampleRate) {
                this.sampleRate = sampleRate;
                return this;
            }

            public int getSamples() {
                return this.samples;
            }

            public Builder setSamples(byte samples) {
                this.samples = samples;
                return this;
            }

            public int getChannel() {
                return this.channel;
            }

            public Builder setChannel(byte channel) {
                this.channel = channel;
                return this;
            }

            public FormatValue<T> getFormat() {
                return this.format;
            }

            public Builder setFormatValue(FormatValue<T> format) {
                this.format = format;
                return this;
            }

            public int getCodec() {
                return this.codec;
            }

            public Builder setCodec(int codec) {
                this.codec = codec;
                return this;
            }

            public String getStreamName() {
                return this.streamName;
            }

            public Builder setStreamName(String streamName) {
                this.streamName = streamName;
                return this;
            }

            @Override
            public Factory<T> build() {
                assert (this.protocol != null) : "No protocol defined!";
                return new Factory(this.protocol, this.sampleRate, this.samples, this.channel, this.format, this.codec, this.streamName);
            }
        }
    }
}

