/*
 * Decompiled with CFR 0.152.
 */
package de.kaleidox.vban.packet;

import de.kaleidox.util.model.Builder;
import de.kaleidox.util.model.ByteArray;
import de.kaleidox.vban.Util;
import de.kaleidox.vban.VBAN;
import de.kaleidox.vban.packet.VBANPacketHead;

public class VBANPacket<T>
implements ByteArray {
    public static final int MAX_SIZE = 1436;
    private VBANPacketHead<T> head;
    private byte[] bytes;

    private VBANPacket(VBANPacketHead<T> head) {
        this.head = head;
    }

    public VBANPacket<T> setData(byte[] data) throws IllegalArgumentException {
        if (data.length > 1436) {
            throw new IllegalArgumentException("Data is too large to be sent! Must be smaller than 1436");
        }
        this.bytes = data;
        return this;
    }

    @Override
    public byte[] getBytes() {
        return Util.appendByteArray(this.head.getBytes(), this.bytes);
    }

    public static class Factory<T>
    implements de.kaleidox.util.model.Factory<VBANPacket<T>> {
        private final VBANPacketHead.Factory<T> headFactory;

        private Factory(VBANPacketHead.Factory<T> headFactory) {
            this.headFactory = headFactory;
        }

        @Override
        public VBANPacket<T> create() {
            return new VBANPacket((VBANPacketHead)this.headFactory.create());
        }

        @Override
        public int counter() {
            return this.headFactory.counter();
        }

        public static <T> Builder<T> builder(VBAN.Protocol<T> protocol) {
            return new Builder(protocol);
        }

        public static class Builder<T>
        implements de.kaleidox.util.model.Builder<Factory<T>> {
            private final VBAN.Protocol<T> protocol;
            private VBANPacketHead.Factory<T> headFactory;

            private Builder(VBAN.Protocol<T> protocol) {
                this.protocol = protocol;
                this.setDefaultFactory();
            }

            public Builder<T> setDefaultFactory() {
                return this.setHeadFactory(VBANPacketHead.defaultFactory(this.protocol));
            }

            public VBANPacketHead.Factory getHeadFactory() {
                return this.headFactory;
            }

            public Builder<T> setHeadFactory(VBANPacketHead.Factory<T> headFactory) {
                this.headFactory = headFactory;
                return this;
            }

            @Override
            public Factory<T> build() {
                return new Factory(this.headFactory);
            }
        }
    }
}

