/*
 * Decompiled with CFR 0.152.
 */
package de.kaleidox.vban;

import de.kaleidox.util.model.Bindable;
import de.kaleidox.util.model.ByteArray;
import de.kaleidox.util.model.Factory;
import de.kaleidox.util.model.IntEnum;
import de.kaleidox.vban.Util;
import de.kaleidox.vban.model.AudioPacket;
import de.kaleidox.vban.model.FormatValue;
import de.kaleidox.vban.model.SRValue;
import de.kaleidox.vban.packet.VBANPacket;
import java.io.IOException;
import java.io.OutputStream;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.InetAddress;
import java.net.SocketException;
import java.net.UnknownHostException;
import org.jetbrains.annotations.NotNull;

public class VBAN<T>
extends OutputStream {
    public static final int DEFAULT_PORT = 6980;
    private final InetAddress address;
    private final int port;
    private Factory<VBANPacket<T>> packetFactory;
    private DatagramSocket socket;
    private byte[] buf = new byte[0];
    private boolean closed = false;

    private VBAN(Factory<VBANPacket<T>> packetFactory, InetAddress address, int port) throws SocketException {
        this.packetFactory = packetFactory;
        this.address = address;
        this.port = port;
        this.socket = new DatagramSocket();
    }

    public VBAN<T> sendData(T data) throws IOException, IllegalArgumentException {
        this.write(Util.createByteArray(data));
        this.flush();
        return this;
    }

    @Override
    public void write(int b) throws IOException {
        if (this.buf.length + 1 > 1436) {
            throw new IOException("Byte array is too large, must be smaller than 1436");
        }
        this.buf = Util.appendByteArray(this.buf, (byte)b);
        if ((char)b == '\n') {
            this.flush();
        }
    }

    @Override
    public synchronized void flush() throws IOException {
        if (this.closed) {
            throw new IOException("Stream is closed");
        }
        if (this.buf.length > 1436) {
            throw new IOException("Byte array is too large, must be smaller than 1436");
        }
        byte[] bytes = this.packetFactory.create().setData(this.buf).getBytes();
        this.socket.send(new DatagramPacket(bytes, bytes.length, this.address, this.port));
        this.buf = new byte[0];
    }

    @Override
    public void close() {
        try {
            this.flush();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        this.socket = null;
        this.packetFactory = null;
        this.closed = true;
    }

    @Deprecated
    public void writeFlush(@NotNull byte[] b) throws IOException {
        super.write(b);
        this.flush();
    }

    @Deprecated
    public void writeFlush(@NotNull byte[] b, int off, int len) throws IOException {
        super.write(b, off, len);
        this.flush();
    }

    public static VBAN<ByteArray> openByteStream(Factory<VBANPacket<ByteArray>> packetFactory, InetAddress address, int port) throws SocketException {
        return new VBAN<ByteArray>(packetFactory, address, port);
    }

    public static VBAN<String> openTextStream(int port) throws SocketException, UnknownHostException {
        return VBAN.openTextStream(InetAddress.getLocalHost(), port);
    }

    public static VBAN<String> openTextStream(InetAddress address, int port) throws SocketException {
        return new VBAN<String>((Factory<VBANPacket<String>>)VBANPacket.Factory.builder(Protocol.TEXT).build(), address, port);
    }

    public static final class Protocol<T>
    implements Bindable<T>,
    IntEnum {
        public static final Protocol<AudioPacket> AUDIO = new Protocol(0);
        public static final Protocol<CharSequence> SERIAL = new Protocol(32);
        public static final Protocol<String> TEXT = new Protocol(64);
        public static final Protocol<ByteArray> SERVICE = new Protocol(96);
        private final int value;

        private Protocol(int value) {
            this.value = value;
        }

        public String name() {
            switch (this.value) {
                case 0: {
                    return "AUDIO";
                }
                case 32: {
                    return "SERIAL";
                }
                case 64: {
                    return "TEXT";
                }
                case 96: {
                    return "SERVICE";
                }
            }
            throw new AssertionError((Object)("Unknown protocol: " + this.toString()));
        }

        public String toString() {
            return String.format("%s-Protocol(%s)", this.name(), Integer.toHexString(this.value));
        }

        @Override
        public int getValue() {
            return this.value;
        }
    }

    public static final class Codec {
        public static final int PCM = 0;
        public static final int VBCA = 16;
        public static final int VBCV = 32;
        public static final int USER = 240;
    }

    public static enum Format implements FormatValue<String>
    {
        BYTE8(0);

        private final int value;

        private Format(int value) {
            this.value = value;
        }

        @Override
        public int getValue() {
            return this.value;
        }
    }

    public static enum AudioFormat implements FormatValue<AudioPacket>
    {
        BYTE8(0),
        INT16(1),
        INT24(2),
        INT32(3),
        FLOAT32(4),
        FLOAT64(5),
        BITS12(6),
        BITS10(7);

        private final int value;

        private AudioFormat(int value) {
            this.value = value;
        }

        @Override
        public int getValue() {
            return this.value;
        }
    }

    public static enum BitsPerSecond implements SRValue<String>
    {
        Bps0,
        Bps110,
        Bps150,
        Bps300,
        Bps600,
        Bps1200,
        Bps2400,
        Bps4800,
        Bps9600,
        Bps14400,
        Bps19200,
        Bps31250,
        Bps38400,
        Bps57600,
        Bps115200,
        Bps128000,
        Bps230400,
        Bps250000,
        Bps256000,
        Bps460800,
        Bps921600,
        Bps1000000,
        Bps1500000,
        Bps2000000,
        Bps3000000;


        @Override
        public int getValue() {
            return this.ordinal();
        }
    }

    public static enum SampleRate implements SRValue<AudioPacket>
    {
        Hz6000,
        Hz12000,
        Hz24000,
        Hz48000,
        Hz96000,
        Hz192000,
        Hz384000,
        Hz8000,
        Hz16000,
        Hz32000,
        Hz64000,
        Hz128000,
        Hz256000,
        Hz512000,
        Hz11025,
        Hz22050,
        Hz44100,
        Hz88200,
        Hz176400,
        Hz352800,
        Hz705600;


        @Override
        public int getValue() {
            return this.ordinal();
        }
    }
}

