/*
 * Decompiled with CFR 0.152.
 */
package de.kaleidox.vban;

import de.kaleidox.util.model.ByteArray;
import de.kaleidox.util.model.Factory;
import de.kaleidox.vban.Util;
import de.kaleidox.vban.packet.VBANPacket;
import de.kaleidox.vban.packet.VBANPacketHead;
import java.io.IOException;
import java.io.OutputStream;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.InetAddress;
import java.net.SocketException;
import org.jetbrains.annotations.NotNull;

public class VBAN<D>
extends OutputStream {
    public static final int DEFAULT_PORT = 6980;
    private final InetAddress address;
    private final int port;
    private Factory<VBANPacket> packetFactory;
    private DatagramSocket socket;
    private byte[] buf = new byte[0];
    private boolean closed = false;

    private VBAN(Factory<VBANPacket> packetFactory, InetAddress address, int port) throws SocketException {
        this.packetFactory = packetFactory;
        this.address = address;
        this.port = port;
        this.socket = new DatagramSocket();
    }

    public VBAN<D> sendData(D data) throws IOException, IllegalArgumentException {
        this.writeFlush(Util.createByteArray(data));
        return this;
    }

    @Override
    public void write(int b) throws IOException {
        if (this.buf.length + 1 > 1436) {
            throw new IOException("Byte array is too large, must be smaller than 1436");
        }
        this.buf = Util.appendByteArray(this.buf, (byte)b);
        if ((char)b == '\n') {
            this.flush();
        }
    }

    @Override
    public synchronized void flush() throws IOException {
        if (this.closed) {
            throw new IOException("Stream is closed");
        }
        if (this.buf.length > 1436) {
            throw new IOException("Byte array is too large, must be smaller than 1436");
        }
        byte[] bytes = this.packetFactory.create().setData(this.buf).getBytes();
        this.socket.send(new DatagramPacket(bytes, bytes.length, this.address, this.port));
        this.buf = new byte[0];
    }

    @Override
    public void close() {
        this.socket = null;
        this.packetFactory = null;
        this.closed = true;
    }

    public void writeFlush(@NotNull byte[] b) throws IOException {
        super.write(b);
        this.flush();
    }

    public void writeFlush(@NotNull byte[] b, int off, int len) throws IOException {
        super.write(b, off, len);
        this.flush();
    }

    public static VBAN<ByteArray> openByteStream(Factory<VBANPacket> packetFactory, InetAddress address, int port) throws SocketException {
        return new VBAN<ByteArray>(packetFactory, address, port);
    }

    public static VBAN<String> openTextStream(InetAddress address, int port) throws SocketException {
        return new VBAN<String>(VBANPacket.Factory.builder().setHeadFactory(VBANPacketHead.defaultTextProtocolFactory()).build(), address, port);
    }

    public final class Codec {
        public static final int PCM = 0;
        public static final int VBCA = 16;
        public static final int VBCV = 32;
        public static final int USER = 240;
    }

    public final class Format {
        public static final int BYTE8 = 0;
        public static final int INT16 = 1;
        public static final int INT24 = 2;
        public static final int INT32 = 3;
        public static final int FLOAT32 = 4;
        public static final int FLOAT64 = 5;
        public static final int BITS12 = 6;
        public static final int BITS10 = 7;
    }

    public final class Protocol {
        public static final int AUDIO = 0;
        public static final int SERIAL = 32;
        public static final int TEXT = 64;
        public static final int SERVICE = 96;
    }

    public final class SampleRate {
        public static final int hz6000 = 0;
        public static final int hz12000 = 1;
        public static final int hz24000 = 2;
        public static final int hz48000 = 3;
        public static final int hz96000 = 4;
        public static final int hz192000 = 5;
        public static final int hz384000 = 6;
        public static final int hz8000 = 7;
        public static final int hz16000 = 8;
        public static final int hz32000 = 9;
        public static final int hz64000 = 10;
        public static final int hz128000 = 11;
        public static final int hz256000 = 12;
        public static final int hz512000 = 13;
        public static final int hz11025 = 14;
        public static final int hz22050 = 15;
        public static final int hz44100 = 16;
        public static final int hz88200 = 17;
        public static final int hz176400 = 18;
        public static final int hz352800 = 19;
        public static final int hz705600 = 20;
    }
}

