/*
 * Decompiled with CFR 0.152.
 */
package de.kaleidox.vban;

import de.kaleidox.util.model.ByteArray;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;

public class Util {
    public static byte[] stringToBytesASCII(String str) {
        if (str == null) {
            return new byte[0];
        }
        byte[] b = new byte[str.length()];
        for (int i = 0; i < b.length; ++i) {
            b[i] = (byte)str.charAt(i);
        }
        return b;
    }

    public static byte[] appendByteArray(byte[] ba1, byte ... ba2) {
        byte[] bytes = new byte[ba1.length + ba2.length];
        System.arraycopy(ba1, 0, bytes, 0, ba1.length);
        System.arraycopy(ba2, 0, bytes, ba1.length, ba2.length);
        return bytes;
    }

    public static byte[] trimArray(byte[] base, int size) {
        byte[] bytes = new byte[size];
        System.arraycopy(base, 0, bytes, 0, base.length);
        return bytes;
    }

    public static byte[] intToByteArray(int integer, int size) {
        return ByteBuffer.allocate(size).putInt(integer).array();
    }

    public static byte[] createByteArray(Object data) {
        if (data instanceof String) {
            return ((String)data).getBytes(StandardCharsets.UTF_8);
        }
        if (data instanceof ByteArray) {
            return ((ByteArray)data).getBytes();
        }
        throw new IllegalArgumentException("Unknown Data Type! Please contact the developer.");
    }
}

