/*
 * Decompiled with CFR 0.152.
 */
package de.kaleidox.vban.packet;

import de.kaleidox.util.model.Builder;
import de.kaleidox.util.model.ByteArray;
import de.kaleidox.vban.Util;
import de.kaleidox.vban.packet.VBANPacketHead;

public class VBANPacket
implements ByteArray {
    public static final int MAX_SIZE = 1436;
    private VBANPacketHead head;
    private byte[] bytes;

    private VBANPacket(VBANPacketHead head) {
        this.head = head;
    }

    public VBANPacket setData(byte[] data) throws IllegalArgumentException {
        if (data.length > 1436) {
            throw new IllegalArgumentException("Data is too large to be sent! Must be smaller than 1436");
        }
        this.bytes = data;
        return this;
    }

    @Override
    public byte[] getBytes() {
        return Util.appendByteArray(this.head.getBytes(), this.bytes);
    }

    public static class Factory
    implements de.kaleidox.util.model.Factory<VBANPacket> {
        private final VBANPacketHead.Factory headFactory;

        private Factory(VBANPacketHead.Factory headFactory) {
            this.headFactory = headFactory;
        }

        @Override
        public VBANPacket create() {
            return new VBANPacket(this.headFactory.create());
        }

        @Override
        public int counter() {
            return this.headFactory.counter();
        }

        public static Builder builder() {
            return new Builder();
        }

        public static class Builder
        implements de.kaleidox.util.model.Builder<Factory> {
            private VBANPacketHead.Factory headFactory;

            private Builder() {
            }

            public VBANPacketHead.Factory getHeadFactory() {
                return this.headFactory;
            }

            public Builder setHeadFactory(VBANPacketHead.Factory headFactory) {
                this.headFactory = headFactory;
                return this;
            }

            @Override
            public Factory build() {
                return new Factory(this.headFactory);
            }
        }
    }
}

