/*
 * Decompiled with CFR 0.152.
 */
package de.kaleidox.vban.packet;

import de.kaleidox.util.Util;
import de.kaleidox.util.model.Builder;
import de.kaleidox.util.model.ByteArray;

public class VBANPacketHead
implements ByteArray {
    public static final int SIZE = 28;
    private final byte[] bytes;

    private VBANPacketHead(int protocol, int sampleRateIndex, byte samples, byte channel, int format, int codec, String streamName, int frameCounter) {
        byte[] bytes = new byte[]{};
        bytes = Util.appendByteArray(bytes, "VBAN".getBytes());
        bytes = Util.appendByteArray(bytes, (byte)(protocol | sampleRateIndex));
        bytes = Util.appendByteArray(bytes, samples, channel);
        bytes = Util.appendByteArray(bytes, (byte)(format | codec));
        bytes = Util.appendByteArray(bytes, Util.minSizeArray(Util.stringToBytesASCII(streamName), 16));
        bytes = Util.appendByteArray(bytes, Util.intToByteArray(frameCounter, 4));
        this.bytes = bytes;
    }

    private byte c(char v) {
        return (byte)v;
    }

    @Override
    public byte[] getBytes() {
        return this.bytes;
    }

    public static Factory defaultAudioProtocolFactory(int channel) throws UnsupportedOperationException {
        throw new UnsupportedOperationException();
    }

    public static Factory defaultTextProtocolFactory() {
        return Factory.builder().setProtocol(64).setChannel((byte)0).setSamples((byte)0).setStreamName("Command1").setSampleRate(18).build();
    }

    public static Factory defaultSerialProtocolFactory() throws UnsupportedOperationException {
        throw new UnsupportedOperationException();
    }

    public static Factory defaultServiceProtocolFactory() throws UnsupportedOperationException {
        throw new UnsupportedOperationException();
    }

    public static class Factory
    implements de.kaleidox.util.model.Factory<VBANPacketHead> {
        private final int protocol;
        private final int sampleRate;
        private final byte samples;
        private final byte channel;
        private final int format;
        private final int codec;
        private final String streamName;
        private int counter = 1;

        private Factory(int protocol, int sampleRate, byte samples, byte channel, int format, int codec, String streamName) {
            this.protocol = protocol;
            this.sampleRate = sampleRate;
            this.samples = samples;
            this.channel = channel;
            this.format = format;
            this.codec = codec;
            this.streamName = streamName;
        }

        @Override
        public synchronized VBANPacketHead create() {
            return new VBANPacketHead(this.protocol, this.sampleRate, this.samples, this.channel, this.format, this.codec, this.streamName, this.counter++);
        }

        @Override
        public synchronized int counter() {
            return this.counter;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static class Builder
        implements de.kaleidox.util.model.Builder<Factory> {
            private int protocol = -1;
            private int sampleRate = 3;
            private byte samples = (byte)-1;
            private byte channel = (byte)2;
            private int format = 1;
            private int codec = 0;
            private String streamName = null;

            private Builder() {
            }

            public int getProtocol() {
                return this.protocol;
            }

            public Builder setProtocol(int protocol) {
                this.protocol = protocol;
                return this;
            }

            public int getSampleRate() {
                return this.sampleRate;
            }

            public Builder setSampleRate(int sampleRate) {
                this.sampleRate = sampleRate;
                return this;
            }

            public byte getSamples() {
                return this.samples;
            }

            public Builder setSamples(byte samples) {
                this.samples = samples;
                return this;
            }

            public byte getChannel() {
                return this.channel;
            }

            public Builder setChannel(byte channel) {
                this.channel = channel;
                return this;
            }

            public int getFormat() {
                return this.format;
            }

            public Builder setFormat(int format) {
                this.format = format;
                return this;
            }

            public int getCodec() {
                return this.codec;
            }

            public Builder setCodec(int codec) {
                this.codec = codec;
                return this;
            }

            public String getStreamName() {
                return this.streamName;
            }

            public Builder setStreamName(String streamName) {
                this.streamName = streamName;
                return this;
            }

            @Override
            public Factory build() {
                assert (this.protocol != -1) : "Protocol is required to be set!";
                assert (this.samples != -1) : "Samples is required to be set!";
                return new Factory(this.protocol, this.sampleRate, this.samples, this.channel, this.format, this.codec, this.streamName);
            }
        }
    }
}

