/*
 * Decompiled with CFR 0.152.
 */
package de.kaleidox.vban;

import de.kaleidox.util.Util;
import de.kaleidox.vban.packet.VBANPacket;
import de.kaleidox.vban.packet.VBANPacketHead;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.SocketException;
import java.util.concurrent.LinkedBlockingQueue;

public class VBAN<D> {
    public static final int DEFAULT_PORT = 6980;
    private final InetAddress address;
    private final int port;
    private final VBANPacket.Factory packetFactory;
    private final DatagramSocket socket;
    private final LinkedBlockingQueue<D> dataQueue;

    private VBAN(VBANPacket.Factory packetFactory, InetSocketAddress socketAddress) throws SocketException {
        this.packetFactory = packetFactory;
        this.address = socketAddress.getAddress();
        this.port = socketAddress.getPort();
        this.socket = new DatagramSocket();
        this.dataQueue = new LinkedBlockingQueue();
    }

    public VBAN<D> sendData(D data) {
        try {
            VBANPacket packet = this.packetFactory.create();
            byte[] bytes = packet.setData(Util.createByteArray(data)).getBytes();
            this.socket.send(new DatagramPacket(bytes, bytes.length, this.address, this.port));
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        return this;
    }

    public static VBAN<String> openTextStream(InetAddress address, int port) throws SocketException {
        return new VBAN<String>(VBANPacket.Factory.builder().setHeadFactory(VBANPacketHead.defaultTextProtocolFactory()).build(), new InetSocketAddress(address, port));
    }

    public final class Codec {
        public static final int PCM = 0;
        public static final int VBCA = 16;
        public static final int VBCV = 32;
        public static final int USER = 240;
    }

    public final class Format {
        public static final int BYTE8 = 0;
        public static final int INT16 = 1;
        public static final int INT24 = 2;
        public static final int INT32 = 3;
        public static final int FLOAT32 = 4;
        public static final int FLOAT64 = 5;
        public static final int BITS12 = 6;
        public static final int BITS10 = 7;
    }

    public final class Protocol {
        public static final int AUDIO = 0;
        public static final int SERIAL = 32;
        public static final int TEXT = 64;
        public static final int SERVICE = 96;
    }

    public final class SampleRate {
        public static final int hz6000 = 0;
        public static final int hz12000 = 1;
        public static final int hz24000 = 2;
        public static final int hz48000 = 3;
        public static final int hz96000 = 4;
        public static final int hz192000 = 5;
        public static final int hz384000 = 6;
        public static final int hz8000 = 7;
        public static final int hz16000 = 8;
        public static final int hz32000 = 9;
        public static final int hz64000 = 10;
        public static final int hz128000 = 11;
        public static final int hz256000 = 12;
        public static final int hz512000 = 13;
        public static final int hz11025 = 14;
        public static final int hz22050 = 15;
        public static final int hz44100 = 16;
        public static final int hz88200 = 17;
        public static final int hz176400 = 18;
        public static final int hz352800 = 19;
        public static final int hz705600 = 20;
    }
}

