/*
 * Decompiled with CFR 0.152.
 */
package de.kaleidox.util.toolchains;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.BinaryOperator;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collector;

public class CustomCollectors {
    public static final Set<Collector.Characteristics> CH_ID = Collections.unmodifiableSet(EnumSet.of(Collector.Characteristics.IDENTITY_FINISH));
    public static final Set<Collector.Characteristics> CH_NOID = Collections.emptySet();
    static final Set<Collector.Characteristics> CH_CONCURRENT_ID = Collections.unmodifiableSet(EnumSet.of(Collector.Characteristics.CONCURRENT, Collector.Characteristics.UNORDERED, Collector.Characteristics.IDENTITY_FINISH));
    static final Set<Collector.Characteristics> CH_CONCURRENT_NOID = Collections.unmodifiableSet(EnumSet.of(Collector.Characteristics.CONCURRENT, Collector.Characteristics.UNORDERED));
    static final Set<Collector.Characteristics> CH_UNORDERED_ID = Collections.unmodifiableSet(EnumSet.of(Collector.Characteristics.UNORDERED, Collector.Characteristics.IDENTITY_FINISH));

    public static Collector<Object, ?, String> toConcatenatedString(Object splitWith) {
        return new CustomCollectorImpl<Object, StringBuilder, String>(StringBuilder::new, (left, right) -> {
            left.append(right.toString());
            left.append(splitWith.toString());
        }, (left, right) -> {
            left.append(right.toString());
            left.append(splitWith.toString());
            return left;
        }, sb -> {
            if (sb.length() > 1) {
                return sb.substring(0, sb.length() - splitWith.toString().length());
            }
            return "";
        }, CH_NOID);
    }

    public static <T> Collector<Collection<T>, Collection<T>, ArrayList<T>> collectionMerge() {
        return new CustomCollectorImpl<Collection<T>, Collection<T>, ArrayList<T>>(ArrayList::new, Collection::addAll, (left, right) -> {
            left.addAll(right);
            return left;
        }, CH_ID);
    }

    public static <T, L extends Collection<T>> Collector<Collection<T>, L, L> collectionMerge(Supplier<L> collectionSupplier) {
        return new CustomCollectorImpl(collectionSupplier, Collection::addAll, (left, right) -> {
            left.addAll(right);
            return left;
        }, CH_ID);
    }

    public static <K, V> Collector<Map<K, V>, HashMap<K, V>, HashMap<K, V>> mapMerge() {
        return new CustomCollectorImpl<Map<K, V>, HashMap<K, V>, HashMap<K, V>>(HashMap::new, (l, r) -> r.forEach(l::putIfAbsent), (l, r) -> {
            r.forEach(l::putIfAbsent);
            return l;
        }, CH_ID);
    }

    public static Collector<Integer, Integer, Integer> sumInteger() {
        return new CustomCollectorImpl<Integer, Integer, Integer>(() -> 0, Integer::sum, Integer::sum, CH_ID);
    }

    public static class CustomCollectorImpl<T, A, R>
    implements Collector<T, A, R> {
        private final Supplier<A> supplier;
        private final BiConsumer<A, T> accumulator;
        private final BinaryOperator<A> combiner;
        private final Function<A, R> finisher;
        private final Set<Collector.Characteristics> characteristics;

        public CustomCollectorImpl(Supplier<A> supplier, BiConsumer<A, T> accumulator, BinaryOperator<A> combiner, Function<A, R> finisher, Set<Collector.Characteristics> characteristics) {
            this.supplier = supplier;
            this.accumulator = accumulator;
            this.combiner = combiner;
            this.finisher = finisher;
            this.characteristics = characteristics;
        }

        public CustomCollectorImpl(Supplier<A> supplier, BiConsumer<A, T> accumulator, BinaryOperator<A> combiner, Set<Collector.Characteristics> characteristics) {
            this(supplier, accumulator, combiner, CustomCollectorImpl.castingIdentity(), characteristics);
        }

        @Override
        public Supplier<A> supplier() {
            return this.supplier;
        }

        @Override
        public BiConsumer<A, T> accumulator() {
            return this.accumulator;
        }

        @Override
        public BinaryOperator<A> combiner() {
            return this.combiner;
        }

        @Override
        public Function<A, R> finisher() {
            return this.finisher;
        }

        @Override
        public Set<Collector.Characteristics> characteristics() {
            return this.characteristics;
        }

        private static <I, R> Function<I, R> castingIdentity() {
            return i -> i;
        }
    }
}

