/*
 * Decompiled with CFR 0.152.
 */
package de.kaleidox.util.serializer;

import de.kaleidox.util.functional.DoubleFunction;
import de.kaleidox.util.serializer.IOPort;
import de.kaleidox.util.serializer.SelectedPropertiesMapper;
import de.kaleidox.util.toolchains.CustomCollectors;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Spliterator;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.stream.Stream;
import org.jetbrains.annotations.Nullable;

public class PropertiesMapper<K, V>
extends ConcurrentHashMap<K, List<V>>
implements Iterable<V> {
    private static final Character[] splitterList = new Character[]{Character.valueOf('\u25aa')};
    protected final ArrayList<Character> deadCharacters = new ArrayList();
    protected final IOPort<ConcurrentHashMap<String, String>, Map<String, String>> ioPort;
    protected final Character splitWith;
    protected final DoubleFunction<String, K> keyFunction;
    protected final DoubleFunction<String, V> valueFunction;

    public PropertiesMapper(File file, DoubleFunction<String, K> keyFunction, DoubleFunction<String, V> valueFunction) {
        this(IOPort.mapPort(file), null, keyFunction, valueFunction);
    }

    public PropertiesMapper(IOPort<ConcurrentHashMap<String, String>, Map<String, String>> ioPort, @Nullable Character splitWith, DoubleFunction<String, K> keyFunction, DoubleFunction<String, V> valueFunction) {
        this.ioPort = ioPort;
        this.splitWith = splitWith == null ? this.selectSplitter() : splitWith;
        this.keyFunction = keyFunction;
        this.valueFunction = valueFunction;
        this.reloadFromFile();
    }

    public Character getSplitWith() {
        return this.splitWith;
    }

    public IOPort<ConcurrentHashMap<String, String>, Map<String, String>> getIoPort() {
        return this.ioPort;
    }

    public SelectedPropertiesMapper<K, V> select(K key) {
        return new SelectedPropertiesMapper<K, V>(this.ioPort, key, this.splitWith, this.keyFunction, this.valueFunction);
    }

    @Override
    public List<V> get(Object key) {
        return (List)super.get(key);
    }

    public V get(K key, int index) {
        this.provideList(key);
        return (V)this.get(key).get(index);
    }

    public V getOrDefault(K key, int index, V valueIfAbsent) {
        this.provideList(key);
        if (this.get(key).size() > index) {
            return (V)this.get(key).get(index);
        }
        return valueIfAbsent;
    }

    public boolean add(K key, V value) {
        this.testForIllegalCharacters(value);
        this.provideList(key);
        boolean add = this.get(key).add(value);
        if (add) {
            this.writeToFile();
        }
        return add;
    }

    public boolean addIfValueAbsent(K key, V value) {
        this.provideList(key);
        if (!this.get(key).contains(value)) {
            boolean add = this.get(key).add(value);
            if (add) {
                this.writeToFile();
            }
            return add;
        }
        return false;
    }

    public boolean addIfPredicate(K key, V value, Predicate<PropertiesMapper<K, V>> mapPredicate) {
        this.provideList(key);
        if (mapPredicate.test(this)) {
            boolean add = this.get(key).add(value);
            if (add) {
                this.writeToFile();
            }
            return add;
        }
        return false;
    }

    public V set(K key, int index, V value) {
        this.provideList(key);
        V set = this.get(key).set(index, value);
        this.writeToFile();
        return set;
    }

    public boolean setIfValueAbsent(K key, int index, V value) {
        this.provideList(key);
        if (!this.get(key).contains(value)) {
            this.get(key).set(index, value);
            this.writeToFile();
            return true;
        }
        return false;
    }

    public boolean setIfPredicate(K key, int index, V value, Predicate<PropertiesMapper<K, V>> mapPredicate) {
        this.provideList(key);
        if (mapPredicate.test(this)) {
            this.get(key).set(index, value);
            this.writeToFile();
            return true;
        }
        return false;
    }

    public boolean setToCoordinates(K key, int index, V value) {
        this.provideList(key);
        if (this.get(key).contains(value) & this.get(key).indexOf(value) != index) {
            this.get(key).set(index, value);
            this.writeToFile();
            return true;
        }
        return false;
    }

    public boolean hasValue(V value) {
        return this.entrySet().stream().anyMatch(e -> ((List)e.getValue()).stream().anyMatch(item -> item.equals(value)));
    }

    public boolean hasKey(K key) {
        return this.entrySet().stream().anyMatch(e -> e.getKey().equals(key));
    }

    public boolean hasValueAtKey(K key, V value) {
        return ((List)this.getOrDefault(key, new ArrayList())).contains(value);
    }

    public boolean removeValues(V value) {
        boolean val = false;
        for (Map.Entry entry : this.entrySet()) {
            ((List)entry.getValue()).remove(value);
            val = true;
        }
        if (val) {
            this.writeToFile();
        }
        return val;
    }

    public List<V> removeKey(K key) {
        List remove = (List)this.remove(key);
        this.writeToFile();
        return remove;
    }

    public boolean removeValueFromKey(K key, V value) {
        boolean remove = this.get(key).remove(value);
        this.writeToFile();
        return remove;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void reloadFromFile() {
        PropertiesMapper propertiesMapper = this;
        synchronized (propertiesMapper) {
            this.ioPort.read().forEach((? super K key, ? super V value) -> {
                K keyItem = this.keyFunction.toOutput((String)key);
                this.putIfAbsent(keyItem, new ArrayList());
                Arrays.asList(value.split(this.splitWith.toString())).forEach((? super T item) -> this.add(keyItem, this.valueFunction.toOutput((String)item)));
            });
            this.notify();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeToFile() {
        PropertiesMapper propertiesMapper = this;
        synchronized (propertiesMapper) {
            HashMap ioWriteMap = new HashMap();
            this.forEach((? super K key, ? super V value) -> {
                String ioPortValues = value.stream().map(this.valueFunction::toInput).collect(CustomCollectors.toConcatenatedString(this.splitWith));
                ioWriteMap.put(this.keyFunction.toInput(key), ioPortValues);
            });
            this.ioPort.write(ioWriteMap);
            this.notify();
        }
    }

    private Character selectSplitter() {
        return Stream.of(splitterList).filter(c -> !this.deadCharacters.contains(c)).findAny().orElseThrow(() -> new IllegalArgumentException("Your input values contain too many illegal characters!\nYou must not use all of the following characters: " + Arrays.toString((Object[])splitterList) + "\nYou may use some of them, but not all of them."));
    }

    private void testForIllegalCharacters(@Nullable V value) {
        if (value == null) {
            this.forEach((? super K key, ? super V lists) -> lists.forEach(this::testForIllegalCharacters));
        } else if (this.valueFunction.toInput(value).contains(this.splitWith.toString())) {
            this.deadCharacters.add(this.splitWith);
            this.selectSplitter();
        }
    }

    void provideList(K atKey) {
        this.putIfAbsent(atKey, new ArrayList());
    }

    @Override
    public Iterator<V> iterator() {
        return new Iterator<V>(){
            List<V> allValues = new ArrayList<V>(){
                {
                    for (Map.Entry entry : PropertiesMapper.super.entrySet()) {
                        this.addAll((Collection)entry.getValue());
                    }
                }
            };
            int bigIndex = 0;

            @Override
            public boolean hasNext() {
                return this.allValues.size() < this.bigIndex;
            }

            @Override
            public V next() {
                Object value = this.allValues.get(this.bigIndex);
                ++this.bigIndex;
                return value;
            }
        };
    }

    @Override
    public void forEach(Consumer<? super V> action) {
        while (this.iterator().hasNext()) {
            action.accept(this.iterator().next());
        }
    }

    @Override
    public Spliterator<V> spliterator() {
        throw new UnsupportedOperationException("Spliterators not implemented yet.");
    }
}

