/*
 * Decompiled with CFR 0.152.
 */
package de.kaleidox.util.serializer;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Supplier;

public class IOPort<R, W> {
    private Supplier<R> reader;
    private Consumer<W> writer;

    public IOPort(Supplier<R> reader, Consumer<W> writer) {
        this.reader = reader;
        this.writer = writer;
    }

    public R read() {
        return this.reader.get();
    }

    public <T extends Collection<String>> Collection<String> readAsCollection(Supplier<T> supplier, String splitWith) {
        return new ArrayList<String>(Arrays.asList(this.reader.get().toString().split(splitWith)));
    }

    public void write(W item) {
        this.writer.accept(item);
    }

    public static IOPort<ConcurrentHashMap<String, String>, Map<String, String>> mapPort(File file) {
        return new IOPort<ConcurrentHashMap<String, String>, Map<String, String>>(() -> {
            Properties props = new Properties();
            ConcurrentHashMap map = new ConcurrentHashMap();
            try {
                props.load(new FileInputStream(file.getPath()));
            }
            catch (IOException e2) {
                e2.printStackTrace();
            }
            props.forEach((BiConsumer<? super Object, ? super Object>)((BiConsumer<Object, Object>)(key, value) -> map.put(key.toString(), value.toString())));
            return map;
        }, item -> {
            Properties props = new Properties();
            for (Map.Entry entry : item.entrySet()) {
                props.put(entry.getKey(), entry.getValue());
            }
            try {
                props.store(new FileOutputStream(file.getPath()), null);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        });
    }
}

