/*
 * Decompiled with CFR 0.152.
 */
package de.kaleidox.util.helpers;

import de.kaleidox.util.helpers.NullHelper;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.TreeMap;
import java.util.WeakHashMap;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentSkipListMap;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.function.Supplier;

public class MapHelper
extends NullHelper {
    public static <K, V> V getEquals(Map<K, V> map, K key, V valueIfAbsent) {
        return (V)map.entrySet().stream().filter(entry -> entry.getKey().equals(key)).map(Map.Entry::getValue).findAny().orElse(valueIfAbsent);
    }

    public static <K, V> boolean containsKey(Map<K, V> map, K key) {
        return map.keySet().stream().anyMatch(check -> check.equals(key));
    }

    public static <K, V> boolean containsValue(Map<K, V> map, V value) {
        return map.values().stream().anyMatch(check -> check.equals(value));
    }

    public static <K, V, T> boolean containsKey(Map<K, V> map, T value, Function<K, T> extractor) {
        return map.keySet().stream().map(extractor).anyMatch(t -> t.equals(value));
    }

    public static <K, V, T> boolean containsValue(Map<K, V> map, T value, Function<V, T> extractor) {
        return map.values().stream().map(extractor).anyMatch(t -> t.equals(value));
    }

    public static <K, V> int countKeyOccurrences(Map<K, V> map, K key) {
        return Math.toIntExact(map.keySet().stream().filter(check -> check.equals(key)).count());
    }

    public static <K, V> int countValueOccurrences(Map<K, V> map, V value) {
        return Math.toIntExact(map.values().stream().filter(check -> check.equals(value)).count());
    }

    public static <K, V> Map<V, List<K>> reverseMap(Map<K, V> map) {
        HashMap newMap = new HashMap();
        MapHelper.getMapOfParent(map, newMap);
        map.forEach((key, value) -> {
            newMap.putIfAbsent(value, new ArrayList());
            ((List)newMap.get(value)).add(key);
        });
        return newMap;
    }

    public static <T> List<T> getAllKeys(Map<T, ?> ofMap) {
        ArrayList<T> val = new ArrayList<T>();
        for (Map.Entry<T, ?> entry : ofMap.entrySet()) {
            val.add(entry.getKey());
        }
        return Collections.unmodifiableList(val);
    }

    public static <T> List<T> getAllValues(Map<?, T> ofMap) {
        ArrayList<T> val = new ArrayList<T>();
        for (Map.Entry<?, T> entry : ofMap.entrySet()) {
            val.add(entry.getValue());
        }
        return Collections.unmodifiableList(val);
    }

    public static <iK, iV, oK, oV, iMap extends TreeMap<iK, iV>, oMap extends TreeMap<oK, oV>> oMap reformat(iMap map, Function<iK, oK> keyMapper, Function<iV, oV> valueMapper, Comparator<oK> replacementComparator) {
        TreeMap reformat = MapHelper.reformat(map, null, keyMapper, valueMapper);
        TreeMap newMap = new TreeMap(replacementComparator);
        newMap.putAll(reformat);
        return (oMap)newMap;
    }

    public static <iK, iV, oK, oV, iMap extends TreeMap<iK, iV>, oMap extends TreeMap<oK, oV>> oMap reformat(iMap map, oMap outputMapPointer, Function<iK, oK> keyMapper, Function<iV, oV> valueMapper, Comparator<oK> replacementComparator) {
        oMap reformat = MapHelper.reformat(map, outputMapPointer, keyMapper, valueMapper);
        outputMapPointer = new TreeMap(replacementComparator);
        ((TreeMap)outputMapPointer).putAll(reformat);
        return (oMap)outputMapPointer;
    }

    public static <iK, iV, oK, oV, iMap extends Map<iK, iV>, oMap extends Map<oK, oV>> oMap reformat(iMap map, Function<iK, oK> keyMapper, Function<iV, oV> valueMapper) {
        return MapHelper.reformat(map, null, keyMapper, valueMapper);
    }

    public static <iK, iV, oK, oV, iMap extends Map<iK, iV>, oMap extends Map<oK, oV>> oMap reformat(iMap map, oMap outputMapPointer, Function<iK, oK> keyMapper, Function<iV, oV> valueMapper) {
        Comparator comparator = map instanceof TreeMap ? ((TreeMap)map).comparator() : null;
        Map<oK, oV> newMap = (Map<oK, oV>)MapHelper.requireNonNullElse(outputMapPointer, new HashMap());
        newMap = MapHelper.getMapOfParent(map, newMap);
        for (Map.Entry<iK, iV> entry : map.entrySet()) {
            newMap.put(keyMapper.apply(entry.getKey()), valueMapper.apply(entry.getValue()));
        }
        if (Objects.nonNull(comparator)) {
            TreeMap<oK, oV> treeMap = new TreeMap<oK, oV>(comparator);
            treeMap.putAll(newMap);
            return (oMap)treeMap;
        }
        return (oMap)newMap;
    }

    private static <iK, iV, oK, oV> Map<oK, oV> getMapOfParent(Map<iK, iV> inputMap, Map<oK, oV> outputMap) {
        Objects.requireNonNull(outputMap);
        outputMap = inputMap instanceof ConcurrentHashMap ? new ConcurrentHashMap<oK, oV>() : (inputMap instanceof TreeMap ? new TreeMap<oK, oV>() : (inputMap instanceof WeakHashMap ? new WeakHashMap<oK, oV>() : (inputMap instanceof LinkedHashMap ? new LinkedHashMap<oK, oV>() : (inputMap instanceof ConcurrentSkipListMap ? new ConcurrentSkipListMap<oK, oV>() : new HashMap<oK, oV>()))));
        return outputMap;
    }

    public static <K, V, T> V getSpecial(Map<K, V> map, T superKey, Supplier<V> defaultValue, Function<K, T> keyFunction) {
        if (!MapHelper.containsKey(map, superKey, keyFunction)) {
            return defaultValue.get();
        }
        return (V)map.entrySet().stream().filter(entry -> keyFunction.apply(entry.getKey()).equals(superKey)).map(Map.Entry::getValue).findAny().orElseGet(defaultValue);
    }

    public static <K, V, T> V getSpecialComparator(Map<K, V> map, T superKey, Supplier<V> defaultValue, BiFunction<K, T, Boolean> keyFunction) {
        return (V)map.entrySet().stream().filter(entry -> (Boolean)keyFunction.apply(entry.getKey(), superKey)).map(Map.Entry::getValue).findAny().orElseGet(defaultValue);
    }
}

