/*
 * Decompiled with CFR 0.152.
 */
package de.kaleidox.util.helpers;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.JsonNodeFactory;
import com.fasterxml.jackson.databind.node.ObjectNode;
import de.kaleidox.util.helpers.ListHelper;
import de.kaleidox.util.helpers.NullHelper;
import de.kaleidox.util.interfaces.JsonNodeable;
import java.io.IOException;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.function.Function;
import java.util.stream.Stream;

public final class JsonHelper
extends NullHelper {
    public static JsonNode nodeOf(Object of) {
        if (of == null) {
            return JsonNodeFactory.instance.nullNode();
        }
        if (of instanceof JsonNode) {
            return (JsonNode)of;
        }
        if (of instanceof JsonNodeable) {
            return ((JsonNodeable)of).toJsonNode();
        }
        if (of instanceof Collection) {
            return JsonHelper.arrayNode((Collection)of);
        }
        if (of instanceof Stream) {
            return JsonHelper.arrayNode(((Stream)of).toArray());
        }
        if (of instanceof Integer) {
            return JsonNodeFactory.instance.numberNode((Integer)of);
        }
        if (of instanceof Long) {
            return JsonNodeFactory.instance.numberNode((Long)of);
        }
        if (of instanceof Double) {
            return JsonNodeFactory.instance.numberNode((Double)of);
        }
        if (of instanceof String) {
            return JsonNodeFactory.instance.textNode((String)of);
        }
        if (of instanceof Boolean) {
            return JsonNodeFactory.instance.booleanNode(((Boolean)of).booleanValue());
        }
        return JsonNodeFactory.instance.textNode(of.toString());
    }

    public static Object ofNode(JsonNode f) {
        Object r = f.isTextual() ? f.asText() : (f.isInt() ? Integer.valueOf(f.asInt()) : (f.isLong() ? Long.valueOf(f.asLong()) : (f.isDouble() ? Double.valueOf(f.asDouble()) : (f.isFloat() ? Float.valueOf(f.floatValue()) : (f.isBoolean() ? Boolean.valueOf(f.asBoolean()) : f.textValue())))));
        return r;
    }

    public static <T, N> ArrayNode arrayNode(List<T> items, Function<T, N> mapper) {
        ArrayNode node = JsonNodeFactory.instance.arrayNode(items.size());
        for (T item : items) {
            node.add(JsonHelper.nodeOf(mapper.apply(item)));
        }
        return node;
    }

    public static <T> ArrayNode arrayNode(Collection<T> items) {
        ArrayNode node = JsonNodeFactory.instance.arrayNode(items.size());
        for (T item : items) {
            node.add(JsonHelper.nodeOf(item));
        }
        return node;
    }

    public static ArrayNode arrayNode(Object ... items) {
        ArrayNode node = JsonNodeFactory.instance.arrayNode(items.length);
        for (Object item : items) {
            node.add(JsonHelper.nodeOf(item));
        }
        return node;
    }

    public static ObjectNode objectNode(Object ... data) {
        if (data.length == 0) {
            return JsonNodeFactory.instance.objectNode();
        }
        if (data.length % 2 != 0) {
            throw new IllegalArgumentException("You must provide an even amount of objects to be placed in the node.");
        }
        ObjectNode objectNode = JsonHelper.objectNode(new Object[0]);
        for (List<Object> pair : ListHelper.everyOfList(2, ListHelper.of(data))) {
            if (!Objects.nonNull(pair.get(0)) || !Objects.nonNull(pair.get(1))) continue;
            objectNode.set(pair.get(0).toString(), JsonHelper.nodeOf(pair.get(1)));
        }
        return objectNode;
    }

    public static JsonNode parse(String body) {
        try {
            return new ObjectMapper().readTree(body);
        }
        catch (IOException e) {
            return JsonHelper.objectNode(new Object[0]);
        }
    }

    public static JsonNode parseExceptional(String body) throws IOException {
        return new ObjectMapper().readTree(body);
    }
}

