/*
 * Decompiled with CFR 0.152.
 */
package de.kaleidox.util.helpers;

import de.kaleidox.util.helpers.ListHelper;
import de.kaleidox.util.helpers.NullHelper;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.CompletableFuture;

public class FutureHelper
extends NullHelper {
    @SafeVarargs
    public static <T> CompletableFuture<T> linkFutures(CompletableFuture<T> parentFuture, CompletableFuture<T> ... others) {
        ListHelper.of(others).forEach(otherFuture -> {
            parentFuture.thenAcceptAsync(otherFuture::complete);
            parentFuture.exceptionally(throwable -> {
                otherFuture.completeExceptionally((Throwable)throwable);
                return null;
            });
        });
        return parentFuture;
    }

    public static <U> CompletableFuture<List<U>> waitForCompletion(Collection<CompletableFuture<U>> futures) {
        CompletableFuture val = new CompletableFuture();
        ArrayList returnVals = new ArrayList();
        CompletableFuture.supplyAsync(() -> new int[0]).thenAcceptAsync(a -> {
            boolean stop = false;
            while (!stop) {
                for (CompletableFuture future : futures) {
                    if (future.isDone()) {
                        returnVals.add(future.join());
                    }
                    if (!future.isCancelled()) continue;
                    futures.remove(future);
                }
                if (returnVals.size() != futures.size()) continue;
                val.complete(returnVals);
                stop = true;
            }
        });
        return val;
    }

    public static <T> CompletableFuture<T> newFuture() {
        return new CompletableFuture();
    }

    public static <T> CompletableFuture<T> failedFuture(Throwable throwable) {
        CompletableFuture<T> future = FutureHelper.newFuture();
        future.completeExceptionally(throwable);
        return future;
    }
}

