/*
 * Decompiled with CFR 0.152.
 */
package de.kaleidox.util.functional;

import java.util.ArrayList;
import java.util.List;
import java.util.function.BiFunction;
import java.util.function.Consumer;

public class Switch<T> {
    private final BiFunction<T, T, Boolean> checker;
    private final List<Case> cases;
    private Consumer<T> defaultExecutor;

    public Switch(BiFunction<T, T, Boolean> checker) {
        this.checker = checker;
        this.cases = new ArrayList<Case>();
    }

    public Switch<T> addCase(T item, Consumer<T> executor) {
        this.cases.add(new Case(item, executor));
        return this;
    }

    public Switch<T> defaultCase(Consumer<T> defaultExecutor) {
        this.defaultExecutor = defaultExecutor;
        return this;
    }

    public void test(T item) {
        boolean needDefault = true;
        for (Case kase : this.cases) {
            if (!this.checker.apply(item, kase.item).booleanValue()) continue;
            needDefault = false;
            kase.executor.accept(item);
        }
        if (needDefault && this.defaultExecutor != null) {
            this.defaultExecutor.accept(item);
        }
    }

    private class Case {
        private final T item;
        private final Consumer<T> executor;

        private Case(T item, Consumer<T> executor) {
            this.item = item;
            this.executor = executor;
        }
    }
}

