/*
 * Decompiled with CFR 0.152.
 */
package de.kaleidox.util.functional;

import java.util.function.Function;

public class DoubleFunction<In, Out> {
    public static final DoubleFunction<String, Object> STRING_OBJECT = new DoubleFunction<String, Object>(a -> a, Object::toString);
    public static final DoubleFunction<String, Integer> STRING_INTEGER = new DoubleFunction<String, Integer>(Integer::parseInt, String::valueOf);
    public static final DoubleFunction<String, Long> STRING_LONG = new DoubleFunction<String, Long>(Long::parseLong, String::valueOf);
    public static final DoubleFunction<String, Double> STRING_DOUBLE = new DoubleFunction<String, Double>(Double::parseDouble, String::valueOf);
    public static final DoubleFunction<String, Float> STRING_FLOAT = new DoubleFunction<String, Float>(Float::parseFloat, String::valueOf);
    private final Function<In, Out> inputFunction;
    private final Function<Out, In> outputFunction;

    public DoubleFunction(Function<In, Out> inputFunction, Function<Out, In> outputFunction) {
        this.inputFunction = inputFunction;
        this.outputFunction = outputFunction;
    }

    public Out toOutput(In item) {
        return this.inputFunction.apply(item);
    }

    public In toInput(Out item) {
        return this.outputFunction.apply(item);
    }

    public static <T> DoubleFunction<T, T> identity() {
        return new DoubleFunction<Object, Object>(a -> a, b -> b);
    }
}

