/*
 * Decompiled with CFR 0.152.
 */
package de.kaleidox.util.config;

import com.fasterxml.jackson.core.JsonPointer;
import com.fasterxml.jackson.databind.JsonNode;
import de.kaleidox.util.helpers.JsonHelper;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.function.Function;

public class Configuration
extends Hashtable<String, ConfigNode> {
    public static final String BASE_PATH = "config/";

    public Configuration(String name) {
        File file = new File(BASE_PATH + name);
        try {
            InputStream resStream = ClassLoader.getSystemResourceAsStream(BASE_PATH + name);
            if (resStream != null) {
                this.readFile(resStream);
            } else {
                if (!file.exists()) {
                    file.createNewFile();
                }
                this.readFile(new FileInputStream(file));
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public Configuration register(String varName, Object value) {
        return this.register(varName, value, Function.identity());
    }

    public <T> Configuration register(String varName, T value, Function<Object, T> mapper) {
        if (this.containsKey(varName)) {
            ConfigNode node = (ConfigNode)this.get(varName);
            node.def = value;
            node.mapper = mapper;
        } else {
            this.put(varName, new ConfigNode(value, mapper));
        }
        return this;
    }

    public String var(String varName) throws NoSuchElementException {
        return this.var(varName, Object.class).toString();
    }

    public <V> V var(String varName, Class<V> as) throws NoSuchElementException, ClassCastException {
        return as.cast(this.getRaw(varName));
    }

    private Object getRaw(String varName) throws NoSuchElementException {
        if (this.containsKey(varName)) {
            ConfigNode configNode = (ConfigNode)this.get(varName);
            return configNode.mapper.apply(configNode.get());
        }
        throw new NoSuchElementException("Variable not found: " + varName);
    }

    private void readFile(InputStream stream) throws IOException, IllegalArgumentException {
        int r;
        StringBuilder sb = new StringBuilder();
        while ((r = stream.read()) != -1) {
            sb.append((char)r);
        }
        this.dissolveNode(JsonHelper.parseExceptional(sb.toString()), "");
    }

    private void dissolveNode(JsonNode node, String underlying) throws IllegalArgumentException {
        if (node.isArray()) {
            throw new IllegalArgumentException("ArrayNodes are currently unsupported!");
        }
        Iterator fields = node.fieldNames();
        while (fields.hasNext()) {
            String name = (String)fields.next();
            JsonNode field = node.path(name);
            String path = String.format("%s%s%s", underlying, underlying.equals("") ? "" : ".", name);
            if (field.isObject()) {
                this.dissolveNode(field, path);
                continue;
            }
            Object ofNode = JsonHelper.ofNode(field);
            if (!this.containsKey(path)) {
                this.put(path, new ConfigNode(ofNode, Function.identity()));
                continue;
            }
            throw new AssertionError();
        }
    }

    private static JsonPointer buildPointer(String from) {
        return JsonPointer.compile((String)("/" + String.join((CharSequence)"/", from.split("."))));
    }

    protected class ConfigNode {
        protected final Object act;
        protected Object def;
        protected Function<Object, ?> mapper;
        private boolean lock = false;

        private ConfigNode(Object act, Function<Object, ?> mapper) {
            this.act = act;
            this.mapper = mapper;
        }

        private void def(Object def) {
            if (this.lock) {
                throw new IllegalAccessError("Node has been locked!");
            }
            this.def = def;
            this.lock = true;
        }

        private Object get() {
            return this.act == null ? this.def : this.act;
        }
    }
}

