/*
 * Decompiled with CFR 0.152.
 */
package de.kaleidox.util;

import java.util.Collection;
import java.util.Optional;
import java.util.function.Predicate;
import java.util.stream.Stream;

public enum LogicalOperator {
    UNKNOWN("unknown"),
    AND("and"),
    OR("or"),
    NOT("not"),
    XOR("xor");

    String name;

    private LogicalOperator(String name) {
        this.name = name;
    }

    public String toString() {
        return "LogicalOperator (" + this.name + ")";
    }

    public boolean test(Stream<Boolean> booleans) {
        if (this == UNKNOWN) {
            throw new NullPointerException();
        }
        switch (this) {
            case AND: {
                return booleans.allMatch(b -> b);
            }
            case OR: {
                return booleans.anyMatch(b -> b);
            }
            case XOR: {
                return booleans.filter(b -> b).count() > 1L;
            }
            case NOT: {
                return booleans.noneMatch(b -> b);
            }
        }
        return false;
    }

    public <T> boolean test(Predicate<T> predicate, Collection<T> collection) {
        return this.test(collection.stream().map(predicate::test));
    }

    public String getName() {
        return this.name;
    }

    public static Optional<LogicalOperator> find(String tag) {
        return Stream.of(LogicalOperator.values()).filter(lo -> lo.name.equalsIgnoreCase(tag)).findAny();
    }
}

