/*
 * Decompiled with CFR 0.152.
 */
package de.kaleidox.util;

import de.kaleidox.util.functional.Evaluation;
import java.util.ArrayList;
import java.util.List;

public class Difference<T> {
    private final List<T> added;
    private final List<T> removed;

    private Difference(List<T> added, List<T> removed) {
        this.added = added;
        this.removed = removed;
    }

    public List<T> getAdded() {
        return this.added;
    }

    public Evaluation<Boolean> hasAdded() {
        return Evaluation.of(!this.added.isEmpty());
    }

    public List<T> getRemoved() {
        return this.removed;
    }

    public Evaluation<Boolean> hasRemoved() {
        return Evaluation.of(!this.removed.isEmpty());
    }

    public static <T> Difference<T> of(List<T> added, List<T> removed) {
        return new Difference<T>(added, removed);
    }

    public static class Builder<A> {
        private final List<A> added = new ArrayList<A>();
        private final List<A> removed = new ArrayList<A>();

        public void addAdded(A item) {
            this.added.add(item);
        }

        public void addRemoved(A item) {
            this.removed.add(item);
        }

        public Difference<A> build() {
            return new Difference(this.added, this.removed);
        }
    }
}

