/*
 * Decompiled with CFR 0.152.
 */
package de.kaleidox.util.serializer;

import de.kaleidox.util.functional.DoubleFunction;
import de.kaleidox.util.serializer.IOPort;
import de.kaleidox.util.serializer.PropertiesMapper;
import java.io.File;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Predicate;
import org.jetbrains.annotations.Nullable;

public class SelectedPropertiesMapper<K, V>
extends PropertiesMapper<K, V>
implements Iterable<V> {
    final K key;

    public SelectedPropertiesMapper(File file, K key, DoubleFunction<String, K> keyFunction, DoubleFunction<String, V> valueFunction) {
        this(IOPort.mapPort(file), key, null, keyFunction, valueFunction);
    }

    public SelectedPropertiesMapper(IOPort<ConcurrentHashMap<String, String>, Map<String, String>> ioPort, K key, @Nullable Character splitWith, DoubleFunction<String, K> keyFunction, DoubleFunction<String, V> valueFunction) {
        super(ioPort, splitWith, keyFunction, valueFunction);
        this.key = key;
    }

    @Override
    public Character getSplitWith() {
        return this.splitWith;
    }

    @Override
    public IOPort<ConcurrentHashMap<String, String>, Map<String, String>> getIoPort() {
        return this.ioPort;
    }

    public K getKey() {
        return this.key;
    }

    public List<V> get() {
        return this.get(this.key);
    }

    public V get(int index) {
        return this.get(this.key, index);
    }

    public V getOrDefault(int index, V valueIfAbsent) {
        return this.getOrDefault(this.key, index, valueIfAbsent);
    }

    public boolean add(V value) {
        return this.add(this.key, value);
    }

    public boolean addIfValueAbsent(V value) {
        return this.addIfValueAbsent(this.key, value);
    }

    public boolean addIfPredicate(V value, Predicate<PropertiesMapper<K, V>> mapPredicate) {
        this.provideList(this.key);
        if (mapPredicate.test(this)) {
            boolean add = this.get(this.key).add(value);
            if (add) {
                this.writeToFile();
            }
            return add;
        }
        return false;
    }

    public V set(int index, V value) {
        return this.set(this.key, index, value);
    }

    public boolean setIfValueAbsent(int index, V value) {
        return this.setIfValueAbsent(this.key, index, value);
    }

    public boolean setIfPredicate(int index, V value, Predicate<PropertiesMapper<K, V>> mapPredicate) {
        this.provideList(this.key);
        if (mapPredicate.test(this)) {
            this.get(this.key).set(index, value);
            this.writeToFile();
            return true;
        }
        return false;
    }

    public boolean setToCoordinates(int index, V value) {
        return this.setToCoordinates(this.key, index, value);
    }

    @Override
    public boolean hasValue(V value) {
        return this.get(this.key).contains(value);
    }
}

