/*
 * Decompiled with CFR 0.152.
 */
package de.kaleidox.util.objects.functional;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;

public class LivingInt {
    public static final long MILLIS_MINIMUM = 20L;
    private final int stopAt;
    private final int stepSize;
    private final List<Runnable> onStopHit;
    private int value;

    public LivingInt(int initialValue, int stopAt, int stepSize, long stepTime, TimeUnit stepUnit) {
        this.value = initialValue;
        this.stopAt = stopAt;
        this.stepSize = stepSize;
        this.onStopHit = new ArrayList<Runnable>();
        if (TimeUnit.MILLISECONDS.convert(stepTime, stepUnit) < 20L) {
            throw new IllegalArgumentException("stepTime must be greater than 50 milliseconds!");
        }
        Executors.newSingleThreadScheduledExecutor().scheduleAtFixedRate(this::step, stepTime, stepTime, stepUnit);
    }

    public synchronized int change(int delta) {
        return this.value += delta;
    }

    public synchronized int set(int set) {
        this.value = set;
        return this.value;
    }

    public synchronized int get() {
        return this.value;
    }

    public synchronized void onStopHit(Runnable runnable) {
        this.onStopHit.add(runnable);
    }

    private synchronized void step() {
        if (this.value == this.stopAt) {
            this.onStopHit.forEach(Runnable::run);
            return;
        }
        this.value += this.stepSize;
    }
}

