/*
 * Decompiled with CFR 0.152.
 */
package de.kaleidox.util.objects.functional;

import java.util.function.Consumer;
import java.util.function.Predicate;

public class Evaluation<T> {
    private final T value;
    private final Predicate<T> tester;
    private final boolean result;

    public Evaluation(T of, Predicate<T> tester) {
        this.value = of;
        this.tester = tester;
        this.result = tester.test(of);
    }

    public static Evaluation<Boolean> of(boolean bool) {
        return new Evaluation<Boolean>(bool, n -> n);
    }

    public String toString() {
        return "Evaluation [" + this.value.toString() + "; tested " + (this.result ? "TRUE" : "FALSE") + "]";
    }

    public T getValue() {
        return this.value;
    }

    public boolean getResult() {
        return this.result;
    }

    public boolean onSuccess(Consumer<T> successAction) {
        if (this.result) {
            successAction.accept(this.value);
        }
        return this.result;
    }

    public boolean onSuccess(Predicate<T> tester, Consumer<T> successAction) {
        if (tester.test(this.value)) {
            successAction.accept(this.value);
            return true;
        }
        return false;
    }

    public boolean onFailure(Consumer<T> failureAction) {
        if (!this.result) {
            failureAction.accept(this.value);
        }
        return this.result;
    }

    public boolean onFailure(Predicate<T> tester, Consumer<T> failureAction) {
        if (tester.test(this.value)) {
            failureAction.accept(this.value);
            return true;
        }
        return false;
    }

    public boolean evaluate(Consumer<T> successAction, Consumer<T> failureAction) {
        boolean b = this.onSuccess(successAction);
        if (!b) {
            failureAction.accept(this.value);
        }
        return b;
    }
}

