/*
 * Decompiled with CFR 0.152.
 */
package de.kaleidox.util.helpers;

import de.kaleidox.util.helpers.NullHelper;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Objects;
import org.jetbrains.annotations.Nullable;

public class UrlHelper
extends NullHelper {
    public static URL ignoreIfNull(String of) {
        if (Objects.nonNull(of)) {
            try {
                return new URL(of);
            }
            catch (MalformedURLException e) {
                return null;
            }
        }
        return null;
    }

    public static URL orNull(String of) {
        if (Objects.nonNull(of)) {
            try {
                return new URL(of);
            }
            catch (MalformedURLException e) {
                return null;
            }
        }
        return null;
    }

    public static boolean equals(@Nullable Object first, @Nullable Object second) {
        if (first == null || second == null) {
            return false;
        }
        if (first.getClass() == second.getClass()) {
            return first.equals(second);
        }
        if (first instanceof String && second instanceof URL) {
            return ((URL)second).toExternalForm().equalsIgnoreCase((String)first);
        }
        if (first instanceof URL && second instanceof String) {
            return ((URL)first).toExternalForm().equalsIgnoreCase((String)second);
        }
        return false;
    }

    public static URL require(String of) {
        Objects.requireNonNull(of);
        try {
            return new URL(of);
        }
        catch (MalformedURLException e) {
            throw new IllegalArgumentException("MalformedURLException: " + e.getMessage());
        }
    }
}

