/*
 * Decompiled with CFR 0.152.
 */
package de.kaleidox.util.helpers;

import de.kaleidox.util.helpers.CollectionHelper;
import de.kaleidox.util.objects.Difference;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Function;
import java.util.function.Supplier;

public class ListHelper
extends CollectionHelper {
    public static <T> List<T> moveList(List<T> list, int distance, Supplier<T> defaultValue) {
        ArrayList<T> newList = new ArrayList<T>();
        for (int i = 0; i < list.size(); ++i) {
            if (list.size() >= i - distance) {
                if (i + distance < 0) continue;
                T item = list.get(i - distance);
                if (!Objects.nonNull(item)) {
                    item = defaultValue.get();
                }
                newList.set(i, item);
                continue;
            }
            newList.set(i, defaultValue.get());
        }
        list = newList;
        return list;
    }

    public static <A, B> Optional<A> findComplex(List<A> list, B criteria, Function<A, B> criteriaExtractor) {
        for (A item : list) {
            if (!criteriaExtractor.apply(item).equals(criteria)) continue;
            return Optional.of(item);
        }
        return Optional.empty();
    }

    public static <T> boolean booleanOfAll(List<T> list, Function<T, Boolean> booleanFunction) {
        int c = 0;
        for (T t : list) {
            if (!booleanFunction.apply(t).booleanValue()) continue;
            ++c;
        }
        return c == list.size();
    }

    public static <T> List<List<T>> everyOfList(int every, List<T> of) {
        ArrayList<List<T>> val = new ArrayList<List<T>>();
        ArrayList<T> count = new ArrayList<T>();
        int i = 0;
        for (int run = 0; run != of.size(); ++run) {
            if (i == every) {
                i = 0;
            }
            if (i == 0) {
                count = new ArrayList();
                val.add(count);
            }
            count.add(of.get(run));
            ++i;
        }
        return val;
    }

    public static <T> boolean equalContents(List<T> a, List<T> b) {
        ListHelper.nullChecks(a, b);
        if (a.size() != b.size()) {
            return false;
        }
        int matches = 0;
        for (int i = 0; i < a.size(); ++i) {
            if (!a.get(i).equals(b.get(i))) continue;
            ++matches;
        }
        return matches == a.size();
    }

    public static <T> boolean containsEquals(List<T> list, T item) {
        ListHelper.requireNoNull(list);
        for (T x : list) {
            if (!x.equals(item)) continue;
            return true;
        }
        return false;
    }

    public static <T> Difference<T> getDifference(List<T> source, List<T> target) {
        ListHelper.nullChecks(source, target);
        Difference.Builder<T> difBuilder = new Difference.Builder<T>();
        for (T x : source) {
            if (ListHelper.containsEquals(target, x)) continue;
            difBuilder.addAdded(x);
        }
        for (T x : target) {
            if (ListHelper.containsEquals(source, x)) continue;
            difBuilder.addRemoved(x);
        }
        return difBuilder.build();
    }

    public static <T> List<T> of(T[] data) {
        ArrayList<T> list = new ArrayList<T>();
        for (T t : data) {
            list.add(t);
        }
        return list;
    }
}

