/*
 * Decompiled with CFR 0.152.
 */
package de.kaleidox.util;

import java.io.File;

public abstract class FileType {
    private final String vanityName;
    private final String regexPiece;

    FileType(String vanityName, String regexPiece) {
        this.vanityName = vanityName;
        this.regexPiece = regexPiece;
    }

    public String toString() {
        return this.regexPiece;
    }

    public boolean isType(String test) {
        return test.matches(".+" + this.regexPiece);
    }

    public boolean isType(File file) {
        return this.isType(file.getName());
    }

    public String vanityName() {
        return this.vanityName;
    }

    public static class VIDEO
    extends FileType {
        public static final VIDEO MP4 = new VIDEO("mp4", ".mp4");
        public static final VIDEO[] ALL = new VIDEO[]{MP4};

        private VIDEO(String vanityName, String regexPiece) {
            super(vanityName, regexPiece);
        }
    }

    public static class MUSIC
    extends FileType {
        public static final MUSIC MP3 = new MUSIC("mp3", ".mp3");
        public static final MUSIC[] ALL = new MUSIC[]{MP3};

        private MUSIC(String vanityName, String regexPiece) {
            super(vanityName, regexPiece);
        }
    }

    public static class IMAGE
    extends FileType {
        public static final IMAGE PNG = new IMAGE("png", ".png");
        public static final IMAGE JPEG = new IMAGE("jpeg", ".jpe?g");
        public static final IMAGE WebP = new IMAGE("webp", ".webp");
        public static final IMAGE GIF = new IMAGE("gif", ".gifv?");
        public static final IMAGE[] ALL = new IMAGE[]{PNG, JPEG, WebP, GIF};
        public static final IMAGE[] NO_GIF = new IMAGE[]{PNG, JPEG, WebP};

        private IMAGE(String vanityName, String regexPiece) {
            super(vanityName, regexPiece);
        }
    }
}

