/*
 * Decompiled with CFR 0.152.
 */
package de.kaleidox.javacord.util.ui.messages;

import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Supplier;
import org.javacord.api.entity.message.Message;
import org.javacord.api.entity.message.Messageable;
import org.javacord.api.event.message.reaction.SingleReactionEvent;

public class PagedMessage {
    private static final ConcurrentHashMap<Messageable, PagedMessage> selfMap = new ConcurrentHashMap();
    private static final String PREV_PAGE_EMOJI = "\u2b05";
    private static final String NEXT_PAGE_EMOJI = "\u27a1";
    private static final int SUITABLE_MAX_LENGTH = 1700;
    private Messageable parent;
    private Supplier<String> head;
    private Supplier<String> body;
    private Message lastMessage = null;
    private List<String> pages = new ArrayList<String>();
    private int page;

    private PagedMessage(Messageable inParent, Supplier<String> head, Supplier<String> body) {
        this.parent = inParent;
        this.head = head;
        this.body = body;
        this.page = 0;
        this.resend();
    }

    public void refresh() {
        this.page = 0;
        this.refreshPage();
    }

    public void refreshPage() {
        this.refreshPages();
        if (this.lastMessage != null) {
            this.lastMessage.edit(this.getPageContent());
        }
    }

    public void resend() {
        this.refreshPages();
        if (this.lastMessage != null) {
            this.lastMessage.delete("Outdated");
        }
        this.parent.sendMessage(this.getPageContent()).thenAcceptAsync(msg -> {
            this.lastMessage = msg;
            msg.addReactionAddListener(this::onPageClick);
            msg.addReactionRemoveListener(this::onPageClick);
            msg.addReaction(PREV_PAGE_EMOJI);
            msg.addReaction(NEXT_PAGE_EMOJI);
        });
    }

    private void onPageClick(SingleReactionEvent event) {
        if (!event.getUser().isYourself()) {
            switch (event.getEmoji().asUnicodeEmoji().orElse("")) {
                case "\u2b05": {
                    if (this.page > 0) {
                        --this.page;
                    }
                    this.refreshPage();
                    break;
                }
                case "\u27a1": {
                    if (this.page < this.pages.size() - 1) {
                        ++this.page;
                    }
                    this.refreshPage();
                }
            }
        }
    }

    private String getPageContent() {
        return this.pages.get(this.page) + "\n\n" + "`Page " + (this.page + 1) + " of " + this.pages.size() + " | " + "Last Refresh: " + new SimpleDateFormat("HH:mm:ss").format(new Timestamp(System.currentTimeMillis())) + " [" + Calendar.getInstance().getTimeZone().getDisplayName() + "]`";
    }

    private void refreshPages() {
        String completeHead = this.head.get();
        String completeBody = this.body.get();
        String completeMessage = completeHead + completeBody;
        List<String> bodyLines = Arrays.asList(completeBody.split("\n"));
        this.pages.clear();
        if (completeMessage.length() < 1700) {
            this.pages.add(completeMessage);
        } else {
            StringBuilder pageBuilder = new StringBuilder(completeHead);
            for (int i = 0; i < bodyLines.size(); ++i) {
                pageBuilder.append(bodyLines.get(i));
                pageBuilder.append("\n");
                if (i != bodyLines.size() - 1 && pageBuilder.length() + bodyLines.get(i + 1).length() < 1700) continue;
                this.pages.add(pageBuilder.toString());
                pageBuilder = new StringBuilder(completeHead);
            }
        }
    }

    public static final PagedMessage get(Messageable forParent, Supplier<String> defaultHead, Supplier<String> defaultBody) {
        if (selfMap.containsKey(forParent)) {
            PagedMessage val = selfMap.get(forParent);
            val.resend();
            return val;
        }
        return selfMap.put(forParent, new PagedMessage(forParent, defaultHead, defaultBody));
    }

    public static final Optional<PagedMessage> get(Messageable forParent) {
        if (selfMap.containsKey(forParent)) {
            PagedMessage val = selfMap.get(forParent);
            val.resend();
            return Optional.of(val);
        }
        return Optional.empty();
    }
}

