/*
 * Decompiled with CFR 0.152.
 */
package de.kaleidox.javacord.util.ui.messages;

import de.kaleidox.javacord.util.embed.EmbedFieldRepresentative;
import de.kaleidox.util.helpers.ListHelper;
import java.util.ArrayList;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicReference;
import org.javacord.api.entity.message.Message;
import org.javacord.api.entity.message.Messageable;
import org.javacord.api.entity.message.embed.EmbedBuilder;
import org.javacord.api.util.logging.ExceptionLogger;
import org.jetbrains.annotations.Nullable;

public class InformationMessage {
    private static final ConcurrentHashMap<Messageable, InformationMessage> selfMap = new ConcurrentHashMap();
    private Messageable messageable;
    private ArrayList<InformationField> fields = new ArrayList();
    private AtomicReference<Message> myMessage = new AtomicReference();

    public InformationMessage(Messageable messageable) {
        this.messageable = messageable;
        selfMap.putIfAbsent(messageable, this);
    }

    public InformationMessage addField(String name, String title, String text) {
        return this.addField(name, title, text, false);
    }

    public InformationMessage addField(String name, String title, String text, boolean inline) {
        this.fields.add(new InformationField(name, title, text, inline));
        return this;
    }

    public InformationMessage editField(String name, String newText) {
        return this.editField(name, null, newText, false);
    }

    public InformationMessage editField(String name, @Nullable String newTitle, String newText) {
        return this.editField(name, newTitle, newText, false);
    }

    public InformationMessage editField(String name, @Nullable String newTitle, String newText, boolean newInline) {
        InformationField field;
        Optional complex = ListHelper.findComplex(this.fields, (Object)name, EmbedFieldRepresentative::getName);
        if (complex.isPresent()) {
            field = (InformationField)complex.get();
            if (newTitle != null) {
                field.setName(newTitle);
            }
        } else {
            throw new NullPointerException("Could not find field: " + name);
        }
        field.setValue(newText);
        field.setInline(newInline);
        return this;
    }

    public InformationMessage removeField(String name) {
        Optional complex = ListHelper.findComplex(this.fields, (Object)name, EmbedFieldRepresentative::getName);
        if (!complex.isPresent()) {
            throw new NullPointerException("Could not find field: " + name);
        }
        InformationField field = (InformationField)complex.get();
        this.fields.remove(field);
        return this;
    }

    public void refresh() {
        EmbedBuilder embed = new EmbedBuilder();
        for (InformationField field : this.fields) {
            embed.addField(field.getName(), field.getValue(), field.isInline());
        }
        if (this.myMessage.get() != null) {
            ((CompletableFuture)this.myMessage.get().delete().thenRunAsync(() -> ((CompletableFuture)this.messageable.sendMessage(embed).thenAcceptAsync(this.myMessage::set)).exceptionally(ExceptionLogger.get((Class[])new Class[0])))).exceptionally(ExceptionLogger.get((Class[])new Class[0]));
        } else {
            ((CompletableFuture)this.messageable.sendMessage(embed).thenAcceptAsync(msg -> this.myMessage.set((Message)msg))).exceptionally(ExceptionLogger.get((Class[])new Class[0]));
        }
    }

    public static final InformationMessage get(Messageable messageable) {
        return selfMap.getOrDefault(messageable, new InformationMessage(messageable));
    }

    class InformationField
    extends EmbedFieldRepresentative {
        private String descr;

        InformationField(String descr, String name, String value, boolean inline) {
            super(name, value, inline);
            this.descr = descr;
        }

        void setName(String name) {
            this.name = name;
        }

        void setValue(String value) {
            this.value = value;
        }

        void setInline(boolean inline) {
            this.inline = inline;
        }
    }
}

