/*
 * Decompiled with CFR 0.152.
 */
package de.kaleidox.javacord.util.commands;

import de.kaleidox.javacord.util.commands.Command;
import de.kaleidox.javacord.util.embed.DefaultEmbedFactory;
import de.kaleidox.javacord.util.server.properties.PropertyGroup;
import de.kaleidox.javacord.util.ui.messages.InformationMessage;
import de.kaleidox.javacord.util.ui.messages.PagedEmbed;
import de.kaleidox.javacord.util.ui.messages.PagedMessage;
import de.kaleidox.javacord.util.ui.messages.RefreshableMessage;
import java.awt.Color;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.apache.logging.log4j.Logger;
import org.javacord.api.DiscordApi;
import org.javacord.api.entity.channel.Channel;
import org.javacord.api.entity.channel.PrivateChannel;
import org.javacord.api.entity.channel.ServerTextChannel;
import org.javacord.api.entity.channel.TextChannel;
import org.javacord.api.entity.message.Message;
import org.javacord.api.entity.message.MessageAuthor;
import org.javacord.api.entity.message.MessageBuilder;
import org.javacord.api.entity.message.Messageable;
import org.javacord.api.entity.message.embed.EmbedBuilder;
import org.javacord.api.entity.permission.PermissionType;
import org.javacord.api.entity.server.Server;
import org.javacord.api.event.message.MessageCreateEvent;
import org.javacord.api.event.message.MessageDeleteEvent;
import org.javacord.api.event.message.MessageEditEvent;
import org.javacord.api.util.logging.ExceptionLogger;
import org.javacord.core.util.logging.LoggerUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class CommandHandler {
    private static final Logger logger = LoggerUtil.getLogger(CommandHandler.class);
    private final DiscordApi api;
    private final ConcurrentHashMap<String, CommandRep> commands = new ConcurrentHashMap();
    private final ConcurrentHashMap<Long, long[]> responseMap = new ConcurrentHashMap();
    public String[] prefixes;
    public boolean autoDeleteResponseOnCommandDeletion;
    private PropertyGroup authMethodProperty = null;
    private Supplier<EmbedBuilder> embedSupplier = null;
    @Nullable
    private PropertyGroup customPrefixProperty;
    private boolean exclusiveCustomPrefix;

    public CommandHandler(DiscordApi api) {
        this.api = api;
        this.prefixes = new String[]{"!"};
        this.autoDeleteResponseOnCommandDeletion = true;
        this.customPrefixProperty = null;
        this.exclusiveCustomPrefix = false;
        api.addMessageCreateListener(this::handleMessageCreate);
        api.addMessageEditListener(this::handleMessageEdit);
        api.addMessageDeleteListener(this::handleMessageDelete);
    }

    public Set<CommandRep> getCommands() {
        HashSet<CommandRep> reps = new HashSet<CommandRep>();
        this.commands.forEach((s, commandRep) -> reps.add((CommandRep)commandRep));
        return reps;
    }

    public void useDefaultHelp(@Nullable Supplier<EmbedBuilder> embedSupplier) {
        this.embedSupplier = embedSupplier == null ? DefaultEmbedFactory.INSTANCE : embedSupplier;
        this.registerCommands(this);
    }

    public void useCustomPrefixes(@NotNull PropertyGroup propertyGroup, boolean exclusiveCustomPrefix) {
        this.customPrefixProperty = propertyGroup;
        this.exclusiveCustomPrefix = exclusiveCustomPrefix;
    }

    public void registerCommands(Object register) {
        if (register instanceof Class) {
            this.extractCommandRep(null, ((Class)register).getMethods());
        } else if (register instanceof Method) {
            this.extractCommandRep(null, (Method)register);
        } else {
            this.extractCommandRep(register, register.getClass().getMethods());
        }
    }

    public void useAuthManager(PropertyGroup authMethodProperty) {
        this.authMethodProperty = authMethodProperty;
    }

    @Command(aliases={"help"}, usage="help [command]", description="Shows a list of commands and what they do.")
    public Object defaultHelpCommand(Command.Parameters param) {
        if (param.getArguments().length == 0) {
            PagedEmbed embed = new PagedEmbed((Messageable)param.getTextChannel(), this.embedSupplier);
            this.getCommands().forEach(commandRep -> {
                Command cmd = commandRep.annotation;
                String[] aliases = cmd.aliases();
                if (aliases.length == 0) {
                    aliases = new String[]{commandRep.method.getName()};
                }
                embed.addField("__" + aliases[0] + "__: _" + this.prefixes[0] + cmd.usage() + "_", cmd.description());
            });
            return embed;
        }
        if (param.getArguments().length >= 1) {
            EmbedBuilder embed = this.embedSupplier.get();
            Optional<CommandRep> command = this.getCommands().stream().filter(cmd -> {
                for (String alias : cmd.annotation.aliases()) {
                    if (!alias.equalsIgnoreCase(param.getArguments()[0])) continue;
                    return true;
                }
                return false;
            }).findAny();
            if (command.isPresent()) {
                Command cmd2 = command.get().annotation;
                String[] aliases = cmd2.aliases();
                if (aliases.length == 0) {
                    aliases = new String[]{command.get().method.getName()};
                }
                embed.addField("__" + aliases[0] + "__: _" + this.prefixes[0] + cmd2.usage() + "_", cmd2.description());
            } else {
                embed.addField("__Unknown Command__: _" + param.getArguments()[0] + "_", "Type _\"" + this.prefixes[0] + "help\"_ for a list of commands.");
            }
            return embed;
        }
        throw new AssertionError();
    }

    private void extractCommandRep(@Nullable Object invocationTarget, Method ... methods) {
        for (Method method : methods) {
            Command annotation = method.getAnnotation(Command.class);
            if (annotation == null) continue;
            if (!Modifier.isStatic(method.getModifiers()) && Objects.isNull(invocationTarget)) {
                throw new IllegalArgumentException("Invocation Target cannot be null on non-static methods!");
            }
            if (Modifier.isAbstract(method.getModifiers())) {
                throw new AbstractMethodError("Command annotated method cannot be abstract!");
            }
            boolean hasErrored = false;
            if (!annotation.enableServerChat() && annotation.requiredDiscordPermission() != PermissionType.SEND_MESSAGES) {
                logger.error("Command " + method.getName() + "(" + Arrays.stream(method.getParameterTypes()).map(Class::getSimpleName).collect(Collectors.joining(", ")) + "): Conflicting command properties; private-only commands cannot require permissions!");
                hasErrored = true;
            }
            if (!annotation.enableServerChat() && !annotation.enableServerChat()) {
                logger.error("Command " + method.getName() + "(" + Arrays.stream(method.getParameterTypes()).map(Class::getSimpleName).collect(Collectors.joining(", ")) + "): Conflicting command properties; command cannot disallow both private and server chat!");
                hasErrored = true;
            }
            if (hasErrored) continue;
            CommandRep commandRep = new CommandRep(method, annotation, invocationTarget);
            if (annotation.aliases().length > 0) {
                for (String alias : annotation.aliases()) {
                    this.commands.put(alias, commandRep);
                }
                continue;
            }
            this.commands.put(method.getName(), commandRep);
        }
    }

    private void handleMessageCreate(MessageCreateEvent event) {
        Params params = new Params(this.api, event, null, event.getServer().orElse(null), event.getChannel(), event.getMessage(), event.getMessageAuthor());
        this.handleCommand(params.message, event.getChannel(), params);
    }

    private void handleMessageEdit(MessageEditEvent event) {
        Params params = new Params(this.api, null, event, event.getServer().orElse(null), event.getChannel(), event.getMessage().orElseGet(() -> (Message)event.requestMessage().join()), event.getMessageAuthor().orElse(null));
        this.handleCommand(params.message, event.getChannel(), params);
    }

    private void handleMessageDelete(MessageDeleteEvent event) {
        if (this.autoDeleteResponseOnCommandDeletion) {
            long[] ids = this.responseMap.get(event.getMessageId());
            ((CompletableFuture)this.api.getMessageById(ids[0], (TextChannel)this.api.getChannelById(ids[1]).flatMap(Channel::asTextChannel).orElseThrow(AssertionError::new)).thenCompose(Message::delete)).exceptionally(ExceptionLogger.get((Class[])new Class[0]));
        }
    }

    private void handleCommand(Message message, TextChannel channel, Params commandParams) {
        String[] args;
        CommandRep commandRep;
        String content = message.getContent();
        int usedPrefix = -1;
        String[] pref = null;
        if (!message.isPrivateMessage() && this.customPrefixProperty != null) {
            Server server2 = (Server)message.getServer().get();
            if (this.exclusiveCustomPrefix) {
                if (content.indexOf(this.customPrefixProperty.getValue(server2.getId()).asString()) == 0) {
                    usedPrefix = Integer.MAX_VALUE;
                }
            } else {
                pref = new String[this.prefixes.length + 1];
                System.arraycopy(this.prefixes, 0, pref, 0, this.prefixes.length);
                pref[pref.length - 1] = this.customPrefixProperty.getValue(server2.getId()).asString();
                for (int i = 0; i < pref.length; ++i) {
                    if (content.indexOf(pref[i]) != 0) continue;
                    usedPrefix = i;
                }
            }
        } else {
            switch (this.prefixes.length) {
                case 1: {
                    if (content.indexOf(this.prefixes[0]) == 0) {
                        usedPrefix = 0;
                    }
                    break;
                }
                default: {
                    for (int i = 0; i < this.prefixes.length; ++i) {
                        if (content.indexOf(this.prefixes[i]) != 0) continue;
                        usedPrefix = i;
                    }
                    break;
                }
                case 0: {
                    return;
                }
            }
        }
        if (pref == null && usedPrefix < this.prefixes.length) {
            pref = this.prefixes;
        }
        if (usedPrefix == -1 || pref == null) {
            return;
        }
        String[] split = content.split("[\\s&&[^\\n]]++");
        if (pref[usedPrefix].matches("^(.*\\s.*)+$")) {
            commandRep = this.commands.get(split[1]);
            args = new String[split.length - 2];
            System.arraycopy(split, 2, args, 0, args.length);
        } else {
            commandRep = this.commands.get(split[0].substring(pref[usedPrefix].length()));
            args = new String[split.length - 1];
            System.arraycopy(split, 1, args, 0, args.length);
        }
        if (commandRep == null) {
            return;
        }
        Params.access$302(commandParams, args);
        ArrayList<String> problems = new ArrayList<String>();
        if (message.isPrivateMessage() && !commandRep.annotation.enablePrivateChat()) {
            problems.add("This command can only be run in a server channel!");
        } else if (!message.isPrivateMessage() && !commandRep.annotation.enableServerChat()) {
            problems.add("This command can only be run in a private channel!");
        }
        switch (this.authMethodProperty == null ? "discord_permission" : commandParams.getServer().map(server -> this.authMethodProperty.getValue((Server)server).asString()).orElse("discord_permission")) {
            case "allow_all": {
                break;
            }
            case "discord_permission": {
                if (message.getUserAuthor().map(usr -> message.getChannel().asServerTextChannel().map(stc -> stc.hasAnyPermission(usr, new PermissionType[]{PermissionType.ADMINISTRATOR, commandRep.annotation.requiredDiscordPermission()})).orElse(true)).orElse(false).booleanValue()) break;
                problems.add("You are missing the required permission: " + commandRep.annotation.requiredDiscordPermission().name() + "!");
                break;
            }
            default: {
                throw new AssertionError((Object)"Unreachable statement reached");
            }
        }
        int reqChlMent = commandRep.annotation.requiredChannelMentions();
        if (message.getMentionedChannels().size() < reqChlMent) {
            problems.add("This command requires at least " + reqChlMent + " channel mention" + (reqChlMent == 1 ? "" : "s") + "!");
        }
        int reqUsrMent = commandRep.annotation.requiredUserMentions();
        if (message.getMentionedUsers().size() < reqUsrMent) {
            problems.add("This command requires at least " + reqUsrMent + " user mention" + (reqUsrMent == 1 ? "" : "s") + "!");
        }
        int reqRleMent = commandRep.annotation.requiredRoleMentions();
        if (message.getMentionedRoles().size() < reqRleMent) {
            problems.add("This command requires at least " + reqRleMent + " role mention" + (reqRleMent == 1 ? "" : "s") + "!");
        }
        if (commandRep.annotation.runInNSFWChannelOnly() && !channel.asServerTextChannel().map(ServerTextChannel::isNsfw).orElse(true).booleanValue()) {
            problems.add("This command can only run in an NSFW marked channel!");
        }
        if (problems.size() > 0) {
            this.applyResponseDeletion(message.getId(), (CompletableFuture<Message>)channel.sendMessage(DefaultEmbedFactory.create().setColor(Color.RED).setDescription(String.join((CharSequence)"\n", problems))).exceptionally(ExceptionLogger.get((Class[])new Class[0])));
            return;
        }
        if (commandRep.annotation.async()) {
            this.api.getThreadPool().getExecutorService().submit(() -> this.doInvoke(commandRep, commandParams, channel, message));
        } else {
            this.doInvoke(commandRep, commandParams, channel, message);
        }
    }

    private void doInvoke(CommandRep commandRep, Params commandParams, TextChannel channel, Message message) {
        Object reply;
        try {
            reply = this.invoke(commandRep.method, commandParams, commandRep.invocationTarget);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException("Cannot access command method!", e);
        }
        catch (InvocationTargetException e) {
            throw new RuntimeException("Command method threw an Exception!", e);
        }
        if (reply != null) {
            CompletableFuture msgFut = null;
            if (reply instanceof EmbedBuilder) {
                msgFut = channel.sendMessage((EmbedBuilder)reply);
            } else if (reply instanceof MessageBuilder) {
                msgFut = ((MessageBuilder)reply).send(channel);
            } else if (reply instanceof InformationMessage) {
                ((InformationMessage)reply).refresh();
            } else if (reply instanceof PagedEmbed) {
                msgFut = ((PagedEmbed)reply).build();
            } else if (reply instanceof PagedMessage) {
                ((PagedMessage)reply).refresh();
            } else if (reply instanceof RefreshableMessage) {
                ((RefreshableMessage)reply).refresh();
            } else {
                msgFut = channel.sendMessage(String.valueOf(reply));
            }
            if (msgFut != null) {
                this.applyResponseDeletion(message.getId(), (CompletableFuture<Message>)msgFut.exceptionally(ExceptionLogger.get((Class[])new Class[0])));
            }
        }
    }

    private Object invoke(Method method, Params param, @Nullable Object invocationTarget) throws InvocationTargetException, IllegalAccessException {
        Class<?>[] parameterTypes = method.getParameterTypes();
        Object[] args = new Object[parameterTypes.length];
        for (int i = 0; i < parameterTypes.length; ++i) {
            Class<?> klasse = parameterTypes[i];
            if (DiscordApi.class.isAssignableFrom(klasse)) {
                args[i] = param.discord;
                continue;
            }
            if (MessageCreateEvent.class.isAssignableFrom(klasse)) {
                args[i] = param.createEvent;
                continue;
            }
            if (MessageEditEvent.class.isAssignableFrom(klasse)) {
                args[i] = param.editEvent;
                continue;
            }
            if (Server.class.isAssignableFrom(klasse)) {
                args[i] = param.server;
                continue;
            }
            if (Boolean.class.isAssignableFrom(klasse)) {
                args[i] = param.message.isPrivateMessage();
                continue;
            }
            if (TextChannel.class.isAssignableFrom(klasse)) {
                if (ServerTextChannel.class.isAssignableFrom(klasse)) {
                    args[i] = param.textChannel.asServerTextChannel().orElse(null);
                    continue;
                }
                if (PrivateChannel.class.isAssignableFrom(klasse)) {
                    args[i] = param.textChannel.asPrivateChannel().orElse(null);
                    continue;
                }
                args[i] = param.textChannel;
                continue;
            }
            args[i] = Message.class.isAssignableFrom(klasse) ? param.message : (MessageAuthor.class.isAssignableFrom(klasse) ? param.author : (String[].class.isAssignableFrom(klasse) ? param.args : (Command.Parameters.class.isAssignableFrom(klasse) ? param : null)));
        }
        return method.invoke(invocationTarget, args);
    }

    private void applyResponseDeletion(long cmdMsgId, CompletableFuture<Message> message) {
        message.thenAcceptAsync(msg -> {
            if (this.autoDeleteResponseOnCommandDeletion) {
                this.responseMap.put(cmdMsgId, new long[]{msg.getId(), msg.getChannel().getId()});
            }
        });
    }

    private class Params
    implements Command.Parameters {
        private final DiscordApi discord;
        @Nullable
        private final MessageCreateEvent createEvent;
        @Nullable
        private final MessageEditEvent editEvent;
        @Nullable
        private final Server server;
        private final TextChannel textChannel;
        private final Message message;
        private final MessageAuthor author;
        private String[] args;

        private Params(@Nullable DiscordApi discord, @Nullable MessageCreateEvent createEvent, @Nullable MessageEditEvent editEvent, Server server, TextChannel textChannel, @Nullable Message message, MessageAuthor author) {
            this.discord = discord;
            this.createEvent = createEvent;
            this.editEvent = editEvent;
            this.server = server;
            this.textChannel = textChannel;
            this.message = message;
            this.author = author;
        }

        @Override
        public DiscordApi getDiscord() {
            return this.discord;
        }

        @Override
        public Optional<MessageCreateEvent> getMessageCreateEvent() {
            return Optional.ofNullable(this.createEvent);
        }

        @Override
        public Optional<MessageEditEvent> getMessageEditEvent() {
            return Optional.ofNullable(this.editEvent);
        }

        @Override
        public Optional<Server> getServer() {
            return Optional.ofNullable(this.server);
        }

        @Override
        public TextChannel getTextChannel() {
            return this.textChannel;
        }

        @Override
        public Message getCommandMessage() {
            return this.message;
        }

        @Override
        public Optional<MessageAuthor> getCommandExecutor() {
            return Optional.ofNullable(this.author);
        }

        @Override
        public String[] getArguments() {
            return this.args;
        }

        static /* synthetic */ String[] access$302(Params x0, String[] x1) {
            x0.args = x1;
            return x1;
        }
    }

    public class CommandRep {
        public final Method method;
        public final Command annotation;
        @Nullable
        public final Object invocationTarget;

        private CommandRep(Method method, @Nullable Command annotation, Object invocationTarget) {
            this.method = method;
            this.annotation = annotation;
            this.invocationTarget = invocationTarget;
        }
    }
}

