/*
 * Decompiled with CFR 0.152.
 */
package de.kaleidox.javacord.util.commands;

import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.util.List;
import java.util.Optional;
import org.javacord.api.DiscordApi;
import org.javacord.api.entity.channel.PrivateChannel;
import org.javacord.api.entity.channel.ServerTextChannel;
import org.javacord.api.entity.channel.TextChannel;
import org.javacord.api.entity.message.Message;
import org.javacord.api.entity.message.MessageAuthor;
import org.javacord.api.entity.permission.PermissionType;
import org.javacord.api.entity.permission.Role;
import org.javacord.api.entity.server.Server;
import org.javacord.api.entity.user.User;
import org.javacord.api.event.message.MessageCreateEvent;
import org.javacord.api.event.message.MessageEditEvent;

@Retention(value=RetentionPolicy.RUNTIME)
@Target(value={ElementType.METHOD})
public @interface Command {
    public String[] aliases() default {};

    public String description() default "No description provided.";

    public String usage() default "No usage provided.";

    public boolean shownInHelpCommand() default true;

    public boolean enablePrivateChat() default true;

    public boolean enableServerChat() default true;

    public PermissionType requiredDiscordPermission() default PermissionType.SEND_MESSAGES;

    public int requiredChannelMentions() default 0;

    public int requiredUserMentions() default 0;

    public int requiredRoleMentions() default 0;

    public boolean runInNSFWChannelOnly() default false;

    public boolean async() default false;

    public static interface Parameters {
        public DiscordApi getDiscord();

        public Optional<MessageCreateEvent> getMessageCreateEvent();

        public Optional<MessageEditEvent> getMessageEditEvent();

        public Optional<Server> getServer();

        default public boolean isPrivate() {
            return !this.getServer().isPresent();
        }

        public TextChannel getTextChannel();

        default public Optional<ServerTextChannel> getServerTextChannel() {
            return this.getTextChannel().asServerTextChannel();
        }

        default public Optional<PrivateChannel> getPrivateChannel() {
            return this.getTextChannel().asPrivateChannel();
        }

        public Message getCommandMessage();

        default public List<ServerTextChannel> getChannelMentions() {
            return this.getCommandMessage().getMentionedChannels();
        }

        default public List<User> getUserMentions() {
            return this.getCommandMessage().getMentionedUsers();
        }

        default public List<Role> getRoleMentions() {
            return this.getCommandMessage().getMentionedRoles();
        }

        public Optional<MessageAuthor> getCommandExecutor();

        public String[] getArguments();
    }
}

