/*
 * Decompiled with CFR 0.152.
 */
package de.kaleidox.discordemoji.model;

import com.fasterxml.jackson.databind.JsonNode;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.jetbrains.annotations.Nullable;

public class EmojiCategory {
    private static final Map<Integer, EmojiCategory> cache = new HashMap<Integer, EmojiCategory>();
    private final String name;
    private final int index;

    private EmojiCategory(String name, int index) {
        this.name = name;
        this.index = index;
        cache.put(index, this);
    }

    public String getName() {
        return this.name;
    }

    public int getIndex() {
        return this.index;
    }

    private EmojiCategory update(int newIndex) {
        int oldIndex;
        ArrayList<Map.Entry<Integer, EmojiCategory>> entries = new ArrayList<Map.Entry<Integer, EmojiCategory>>(cache.entrySet());
        Map.Entry<Integer, EmojiCategory> oldEntry = entries.get(newIndex);
        for (oldIndex = 0; oldIndex < entries.size() && !entries.get(oldIndex).getValue().equals(oldEntry.getValue()); ++oldIndex) {
        }
        cache.put(newIndex, this);
        cache.put(oldIndex, oldEntry.getValue());
        return this;
    }

    @Nullable
    public static EmojiCategory getByIndex(int index) {
        return cache.getOrDefault(index, null);
    }

    public static EmojiCategory getOrCreate(JsonNode data, int index) {
        return cache.compute(index, (i, category) -> category == null ? new EmojiCategory(data.asText(), (int)i) : category.update((int)i));
    }
}

