/*
 * Decompiled with CFR 0.152.
 */
package de.kaleidox.discordemoji.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.JsonNode;
import de.kaleidox.discordemoji.model.EmojiCategory;
import de.kaleidox.util.PromisedValue;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.OptionalInt;

public class Emoji {
    private static final Map<Integer, Emoji> cache = new HashMap<Integer, Emoji>();
    @JsonProperty(required=true)
    private int id;
    @JsonProperty(required=true)
    private String title;
    @JsonProperty
    private String slug;
    @JsonProperty(value="image", required=true)
    private URL imageUrl;
    @JsonProperty
    private String description;
    @JsonProperty
    private int category;
    @JsonProperty
    private String license;
    @JsonProperty
    private String source;
    @JsonProperty
    private int faves;
    @JsonProperty(value="submitted_by")
    private String submittedBy;
    @JsonProperty
    private int width;
    @JsonProperty
    private int height;
    @JsonProperty
    private int filesize;

    private Emoji(JsonNode data) {
        cache.put(this.id, this.update(data));
    }

    public int getId() {
        return this.id;
    }

    public String getTitle() {
        return this.title;
    }

    public String getSlug() {
        return this.slug;
    }

    public URL getImageURL() {
        return this.imageUrl;
    }

    public String getDescription() {
        return this.description;
    }

    public PromisedValue<Integer, EmojiCategory> getCategory() {
        return new PromisedValue<Integer, EmojiCategory>(this.category, EmojiCategory::getByIndex);
    }

    public Optional<String> getLicense() {
        return this.license.isEmpty() || this.license.equals("0") ? Optional.empty() : Optional.of(this.license);
    }

    public Optional<String> getSource() {
        return this.source.isEmpty() ? Optional.empty() : Optional.of(this.source);
    }

    public int getFaves() {
        return this.faves;
    }

    public String getSubmittedBy() {
        return this.submittedBy;
    }

    public OptionalInt getWidth() {
        return this.width == 0 ? OptionalInt.empty() : OptionalInt.of(this.width);
    }

    public OptionalInt getHeight() {
        return this.height == 0 ? OptionalInt.empty() : OptionalInt.of(this.height);
    }

    public OptionalInt getFilesize() {
        return this.filesize == 0 ? OptionalInt.empty() : OptionalInt.of(this.filesize);
    }

    private Emoji update(JsonNode data) {
        try {
            this.id = data.path("id").asInt(this.id);
            this.title = data.path("title").asText(this.title);
            this.slug = data.path("slug").asText(this.slug);
            String str = data.path("image").asText();
            this.imageUrl = str.equals(this.imageUrl == null ? null : this.imageUrl.toExternalForm()) ? this.imageUrl : new URL(str);
            this.description = data.path("description").asText(this.description);
            this.category = data.path("category").asInt(this.category);
            this.license = data.path("license").asText(this.license);
            this.source = data.path("source").asText(this.source);
            this.faves = data.path("faves").asInt(this.faves);
            this.submittedBy = data.path("submitted_by").asText(this.submittedBy);
            this.width = data.path("width").asInt(this.width);
            this.height = data.path("height").asInt(this.height);
            this.filesize = data.path("filesize").asInt(this.filesize);
        }
        catch (Throwable e) {
            throw new RuntimeException(this.toString() + " update exception", e);
        }
        return this;
    }

    public static Optional<Emoji> getByID(int id) {
        return (cache.size() > 2000 ? cache.entrySet().parallelStream() : cache.entrySet().stream()).filter(entry -> (Integer)entry.getKey() == id).findFirst().map(Map.Entry::getValue);
    }

    public static Emoji getOrCreate(JsonNode data) {
        return cache.compute(data.get("id").asInt(), (id, emoji) -> emoji == null ? new Emoji(data) : emoji.update(data));
    }
}

