/*
 * Decompiled with CFR 0.152.
 */
package de.kaleidox.discordemoji;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import de.kaleidox.discordemoji.model.Emoji;
import de.kaleidox.discordemoji.model.EmojiCategory;
import de.kaleidox.discordemoji.model.EmojiPack;
import de.kaleidox.discordemoji.model.PageStats;
import de.kaleidox.discordemoji.rest.Endpoint;
import de.kaleidox.discordemoji.rest.RestRequestHelper;
import java.util.ArrayList;
import java.util.Collection;
import java.util.concurrent.CompletableFuture;

public final class DiscordEmoji {
    private static final ObjectMapper objectMapper = new ObjectMapper();

    private DiscordEmoji() {
    }

    public static CompletableFuture<Collection<Emoji>> refreshEmojiCache() {
        return ((CompletableFuture)RestRequestHelper.get(Endpoint.LIST_ALL_EMOJIS).thenApply(DiscordEmoji::mapNode_rethrow)).thenApply(node -> {
            ArrayList<Emoji> yields = new ArrayList<Emoji>();
            for (JsonNode emoji : node) {
                yields.add(Emoji.getOrCreate(emoji));
            }
            return yields;
        });
    }

    public static CompletableFuture<Collection<EmojiPack>> refreshEmojiPackCache() {
        return ((CompletableFuture)RestRequestHelper.get(Endpoint.LIST_ALL_PACKS).thenApply(DiscordEmoji::mapNode_rethrow)).thenApply(node -> {
            ArrayList<EmojiPack> yields = new ArrayList<EmojiPack>();
            for (JsonNode emojiPack : node) {
                yields.add(EmojiPack.getOrCreate(emojiPack));
            }
            return yields;
        });
    }

    public static CompletableFuture<Collection<EmojiCategory>> refreshEmojiCategoryCache() {
        return ((CompletableFuture)RestRequestHelper.get(Endpoint.LIST_ALL_CATEGORIES).thenApply(DiscordEmoji::mapNode_rethrow)).thenApply(node -> {
            ArrayList<EmojiCategory> yields = new ArrayList<EmojiCategory>();
            for (int i = 0; i < node.size(); ++i) {
                yields.add(EmojiCategory.getOrCreate(node, i));
            }
            return yields;
        });
    }

    public static CompletableFuture<PageStats> requestPageStats() {
        return RestRequestHelper.get(Endpoint.LIST_WEBSITE_STATS).thenApply(data -> DiscordEmoji.mapObject_rethrow(data, PageStats.class));
    }

    private static <T> T mapObject_rethrow(String data, Class<T> type) throws RuntimeException {
        try {
            return (T)objectMapper.readValue(data, type);
        }
        catch (JsonProcessingException e) {
            throw new RuntimeException("JSON Deserialization Exception", e);
        }
    }

    private static JsonNode mapNode_rethrow(String data) throws RuntimeException {
        try {
            return objectMapper.readTree(data);
        }
        catch (JsonProcessingException e) {
            throw new RuntimeException("JSON Deserialization Exception", e);
        }
    }
}

