/*
 * Decompiled with CFR 0.152.
 */
package de.kaleidox.crystalshard.util.util;

import de.kaleidox.crystalshard.logging.Logger;
import de.kaleidox.crystalshard.main.Discord;
import de.kaleidox.crystalshard.main.handling.listener.Listener;
import de.kaleidox.crystalshard.main.handling.listener.message.generic.MessageDeleteListener;
import de.kaleidox.crystalshard.main.handling.listener.message.reaction.ReactionAddListener;
import de.kaleidox.crystalshard.main.handling.listener.message.reaction.ReactionRemoveListener;
import de.kaleidox.crystalshard.main.items.DiscordItem;
import de.kaleidox.crystalshard.main.items.message.Message;
import de.kaleidox.crystalshard.main.items.message.embed.Embed;
import de.kaleidox.crystalshard.main.items.server.emoji.Emoji;
import de.kaleidox.crystalshard.main.items.server.emoji.UnicodeEmoji;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.atomic.AtomicReference;

public class InfoReaction {
    public static void add(CompletableFuture<Message> msgFut, Emoji emoji, Boolean deleteAfterSend, Embed.Builder infoEmbed) {
        InfoReaction.add(msgFut.join(), emoji, deleteAfterSend, infoEmbed);
    }

    public static void add(Message message, Emoji emoji, Boolean deleteAfterSend, Embed.Builder infoEmbed) {
        AtomicReference sentMessage = new AtomicReference();
        message.addReaction(emoji).exceptionally(Logger::handle);
        MessageDeleteListener deleteListener = event -> {
            message.removeReactionsByEmoji(new Emoji[]{emoji});
            message.delete();
        };
        ReactionAddListener addListener = event -> {
            if (!event.getUser().isYourself()) {
                if (event.getEmoji().toUnicodeEmoji().map(arg_0 -> ((Emoji)emoji).equals(arg_0)).orElse(false).booleanValue()) {
                    ((CompletableFuture)((CompletableFuture)message.getChannel().sendMessage(infoEmbed.build()).thenAccept(myMsg -> {
                        sentMessage.set(myMsg);
                        myMsg.attachListener((Listener)deleteListener);
                    })).thenAccept(nothing -> {
                        if (deleteAfterSend.booleanValue()) {
                            message.delete().exceptionally(Logger::handle);
                        }
                    })).exceptionally(Logger::handle);
                }
            }
        };
        ReactionRemoveListener removeListener = event -> event.getEmoji().toUnicodeEmoji().filter(arg_0 -> ((Emoji)emoji).equals(arg_0)).ifPresent(unicodeEmoji -> {
            if (!event.getUser().isYourself() && event.getUser().equals((DiscordItem)message.getAuthorAsUser().get())) {
                ((Message)sentMessage.get()).delete().exceptionally(Logger::handle);
            }
        });
        message.attachListener((Listener)addListener);
        message.attachListener((Listener)removeListener);
    }

    public static void add(Message message, Embed.Builder infoEmbed) {
        InfoReaction.add(message, (Emoji)UnicodeEmoji.of((Discord)message.getDiscord(), (String)"\u2139"), (Boolean)false, infoEmbed);
    }

    public static void add(CompletableFuture<Message> msgFut, Embed.Builder infoEmbed) {
        Message msg = msgFut.join();
        InfoReaction.add(msg, (Emoji)UnicodeEmoji.of((Discord)msg.getDiscord(), (String)"\u2139"), (Boolean)false, infoEmbed);
    }
}

